/*
Navicat MySQL Data Transfer

Source Server         : mysql 3306
Source Server Version : 50505
Source Host           : localhost:3306
Source Database       : laravel-vuetify

Target Server Type    : MYSQL
Target Server Version : 50505
File Encoding         : 65001

Date: 2023-12-09 08:07:21
*/

SET FOREIGN_KEY_CHECKS=0;

-- ----------------------------
-- Table structure for abonos
-- ----------------------------
DROP TABLE IF EXISTS `abonos`;
CREATE TABLE `abonos` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `cuenta_cobrar_id` bigint(20) unsigned NOT NULL,
  `total_abono` float(9,2) DEFAULT NULL,
  `deuda_capturada` float(9,2) DEFAULT NULL,
  `estatus` varchar(10) NOT NULL DEFAULT 'activo',
  `fecha_registro` datetime NOT NULL DEFAULT current_timestamp(),
  `fecha_modificacion` timestamp NOT NULL DEFAULT current_timestamp(),
  `creado_por` int(11) NOT NULL DEFAULT 1,
  `modificado_por` int(11) NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`),
  KEY `abonos_cuenta_cobrar_id` (`cuenta_cobrar_id`),
  CONSTRAINT `abonos_cuenta_cobrar_id` FOREIGN KEY (`cuenta_cobrar_id`) REFERENCES `cuentas_cobrars` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- ----------------------------
-- Records of abonos
-- ----------------------------

-- ----------------------------
-- Table structure for almacenes
-- ----------------------------
DROP TABLE IF EXISTS `almacenes`;
CREATE TABLE `almacenes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nombre` varchar(500) NOT NULL,
  `sucursal_id` int(11) NOT NULL,
  `fecha_registro` datetime NOT NULL DEFAULT current_timestamp(),
  `fecha_modificacion` timestamp NOT NULL DEFAULT current_timestamp(),
  `creado_por` int(11) NOT NULL DEFAULT 1,
  `modificado_por` int(11) NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`),
  KEY `almacenes_sucursal_id` (`sucursal_id`),
  CONSTRAINT `almacenes_sucursal_id` FOREIGN KEY (`sucursal_id`) REFERENCES `sucursales` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- ----------------------------
-- Records of almacenes
-- ----------------------------

-- ----------------------------
-- Table structure for clientes
-- ----------------------------
DROP TABLE IF EXISTS `clientes`;
CREATE TABLE `clientes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `folio` varchar(45) DEFAULT NULL,
  `rfc` varchar(45) DEFAULT NULL,
  `razonSocial` varchar(250) DEFAULT NULL,
  `celular` varchar(45) DEFAULT NULL,
  `email` text DEFAULT NULL,
  `expediente` text DEFAULT NULL,
  `autorizado_session` varchar(4) NOT NULL DEFAULT 'no',
  `estatus` varchar(10) NOT NULL DEFAULT 'activo',
  `fecha_registro` datetime NOT NULL DEFAULT current_timestamp(),
  `fecha_modificacion` timestamp NOT NULL DEFAULT current_timestamp(),
  `creado_por` int(11) NOT NULL DEFAULT 1,
  `modificado_por` int(11) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL ON UPDATE current_timestamp(),
  `updated_at` timestamp NULL DEFAULT NULL ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- ----------------------------
-- Records of clientes
-- ----------------------------

-- ----------------------------
-- Table structure for config_users_sucursales
-- ----------------------------
DROP TABLE IF EXISTS `config_users_sucursales`;
CREATE TABLE `config_users_sucursales` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL,
  `sucursal_id` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL ON UPDATE current_timestamp(),
  `updated_at` timestamp NULL DEFAULT NULL ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `config_users_sucursales_user_id` (`user_id`),
  KEY `config_users_sucursales_sucursal_id` (`sucursal_id`),
  CONSTRAINT `config_users_sucursales_sucursal_id` FOREIGN KEY (`sucursal_id`) REFERENCES `sucursales` (`id`),
  CONSTRAINT `config_users_sucursales_user_id` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- ----------------------------
-- Records of config_users_sucursales
-- ----------------------------

-- ----------------------------
-- Table structure for cortes_cajas
-- ----------------------------
DROP TABLE IF EXISTS `cortes_cajas`;
CREATE TABLE `cortes_cajas` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `sucursal_id` int(11) NOT NULL,
  `total` double(11,6) NOT NULL DEFAULT 0.000000,
  `subtotal` double(11,6) NOT NULL DEFAULT 0.000000,
  `iva` double(11,6) NOT NULL DEFAULT 0.000000,
  `ieps` double(11,6) NOT NULL DEFAULT 0.000000,
  `total_efectivo` double(11,6) NOT NULL DEFAULT 0.000000,
  `total_tarjeta_debito` double(11,6) NOT NULL DEFAULT 0.000000,
  `total_tarjera_credito` double(11,6) NOT NULL DEFAULT 0.000000,
  `total_tranferencia` double(11,6) NOT NULL,
  `total_credito` double(11,6) NOT NULL,
  `estatus` varchar(10) NOT NULL DEFAULT 'activo',
  `fecha_registro` datetime NOT NULL DEFAULT current_timestamp(),
  `fecha_modificacion` timestamp NOT NULL DEFAULT current_timestamp(),
  `creado_por` int(11) NOT NULL DEFAULT 1,
  `modificado_por` int(11) NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`),
  KEY `cortes_cajas_sucursal_id` (`sucursal_id`),
  CONSTRAINT `cortes_cajas_sucursal_id` FOREIGN KEY (`sucursal_id`) REFERENCES `sucursales` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- ----------------------------
-- Records of cortes_cajas
-- ----------------------------

-- ----------------------------
-- Table structure for creditos_ventas
-- ----------------------------
DROP TABLE IF EXISTS `creditos_ventas`;
CREATE TABLE `creditos_ventas` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `cuenta_cobrar_id` bigint(20) unsigned NOT NULL,
  `venta_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `creditos_ventas_cuenta_cobrar_id` (`cuenta_cobrar_id`),
  KEY `creditos_ventas_venta_id` (`venta_id`),
  CONSTRAINT `creditos_ventas_cuenta_cobrar_id` FOREIGN KEY (`cuenta_cobrar_id`) REFERENCES `cuentas_cobrars` (`id`),
  CONSTRAINT `creditos_ventas_venta_id` FOREIGN KEY (`venta_id`) REFERENCES `ventas` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- ----------------------------
-- Records of creditos_ventas
-- ----------------------------

-- ----------------------------
-- Table structure for cuentas_cobrars
-- ----------------------------
DROP TABLE IF EXISTS `cuentas_cobrars`;
CREATE TABLE `cuentas_cobrars` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `cliente_id` int(11) NOT NULL,
  `deuda_original` float(9,2) NOT NULL,
  `deuda_actual` float(9,2) NOT NULL,
  `pagado` varchar(10) NOT NULL DEFAULT 'no',
  `estatus` varchar(10) NOT NULL DEFAULT 'activo',
  `fecha_registro` datetime NOT NULL DEFAULT current_timestamp(),
  `fecha_modificacion` timestamp NOT NULL DEFAULT current_timestamp(),
  `creado_por` int(11) NOT NULL DEFAULT 1,
  `modificado_por` int(11) NOT NULL DEFAULT 1,
  `ultima_fecha_pagada` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cuentas_cobrars_cliente_id` (`cliente_id`),
  CONSTRAINT `cuentas_cobrars_cliente_id` FOREIGN KEY (`cliente_id`) REFERENCES `clientes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- ----------------------------
-- Records of cuentas_cobrars
-- ----------------------------

-- ----------------------------
-- Table structure for encuestas
-- ----------------------------
DROP TABLE IF EXISTS `encuestas`;
CREATE TABLE `encuestas` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `descripcion` text NOT NULL,
  `estatus` varchar(255) NOT NULL DEFAULT 'activo',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- ----------------------------
-- Records of encuestas
-- ----------------------------

-- ----------------------------
-- Table structure for equipos
-- ----------------------------
DROP TABLE IF EXISTS `equipos`;
CREATE TABLE `equipos` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `nombre_corto` varchar(255) NOT NULL,
  `nombre_lago` varchar(500) DEFAULT NULL,
  `descripcion` text NOT NULL,
  `imagen_entrada` text NOT NULL,
  `imagen_descriptiva` text NOT NULL,
  `tipo_id` int(11) NOT NULL,
  `estatus` varchar(10) NOT NULL DEFAULT 'activo',
  PRIMARY KEY (`id`),
  KEY `equipos_tipo_id` (`tipo_id`),
  CONSTRAINT `equipos_tipo_id` FOREIGN KEY (`tipo_id`) REFERENCES `tipos_equipos` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- ----------------------------
-- Records of equipos
-- ----------------------------

-- ----------------------------
-- Table structure for expedientes
-- ----------------------------
DROP TABLE IF EXISTS `expedientes`;
CREATE TABLE `expedientes` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `cliente_id` int(11) NOT NULL,
  `sucursal_id` int(11) NOT NULL,
  `session_id` bigint(20) unsigned DEFAULT NULL,
  `contenido` text NOT NULL,
  `fecha_registro` datetime NOT NULL DEFAULT current_timestamp(),
  `fecha_modificacion` timestamp NOT NULL DEFAULT current_timestamp(),
  `creado_por` int(11) NOT NULL DEFAULT 1,
  `modificado_por` int(11) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL ON UPDATE current_timestamp(),
  `updated_at` timestamp NULL DEFAULT NULL ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `expedientes_cliente_id` (`cliente_id`),
  KEY `expedientes_sucursal_id` (`sucursal_id`),
  CONSTRAINT `expedientes_cliente_id` FOREIGN KEY (`cliente_id`) REFERENCES `clientes` (`id`),
  CONSTRAINT `expedientes_sucursal_id` FOREIGN KEY (`sucursal_id`) REFERENCES `sucursales` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- ----------------------------
-- Records of expedientes
-- ----------------------------

-- ----------------------------
-- Table structure for failed_jobs
-- ----------------------------
DROP TABLE IF EXISTS `failed_jobs`;
CREATE TABLE `failed_jobs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `uuid` varchar(255) NOT NULL,
  `connection` text NOT NULL,
  `queue` text NOT NULL,
  `payload` longtext NOT NULL,
  `exception` longtext NOT NULL,
  `failed_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `failed_jobs_uuid_unique` (`uuid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ----------------------------
-- Records of failed_jobs
-- ----------------------------

-- ----------------------------
-- Table structure for horarios
-- ----------------------------
DROP TABLE IF EXISTS `horarios`;
CREATE TABLE `horarios` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `sucursal_id` int(11) NOT NULL,
  `dia` decimal(2,0) NOT NULL,
  `hora_entrada` time NOT NULL,
  `hora_salida` time NOT NULL,
  `fecha_registro` datetime NOT NULL DEFAULT current_timestamp(),
  `fecha_modificacion` timestamp NOT NULL DEFAULT current_timestamp(),
  `creado_por` int(11) NOT NULL DEFAULT 1,
  `modificado_por` int(11) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL ON UPDATE current_timestamp(),
  `updated_at` timestamp NULL DEFAULT NULL ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `horario_sucursal_id` (`sucursal_id`),
  CONSTRAINT `horario_sucursal_id` FOREIGN KEY (`sucursal_id`) REFERENCES `sucursales` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- ----------------------------
-- Records of horarios
-- ----------------------------
INSERT INTO `horarios` VALUES ('2', '1', '2', '09:00:00', '19:00:00', '2021-12-07 01:07:29', '2021-12-07 01:07:29', '1', '1', null, null);
INSERT INTO `horarios` VALUES ('3', '1', '3', '09:00:00', '19:00:00', '2021-12-07 01:07:29', '2021-12-07 01:07:29', '1', '1', null, null);
INSERT INTO `horarios` VALUES ('4', '1', '4', '09:00:00', '19:00:00', '2021-12-07 01:07:29', '2021-12-07 01:07:29', '1', '1', null, null);
INSERT INTO `horarios` VALUES ('5', '1', '5', '09:00:00', '19:00:00', '2021-12-07 01:07:29', '2021-12-07 01:07:29', '1', '1', null, null);
INSERT INTO `horarios` VALUES ('6', '1', '6', '09:00:00', '19:00:00', '2021-12-07 01:07:29', '2021-12-07 01:07:29', '1', '1', null, null);
INSERT INTO `horarios` VALUES ('7', '1', '7', '08:00:00', '16:00:00', '2021-12-07 01:07:29', '2021-12-07 01:07:29', '1', '1', null, null);
INSERT INTO `horarios` VALUES ('8', '3', '2', '10:00:00', '20:00:00', '2021-12-07 01:07:29', '2021-12-07 01:07:29', '1', '1', null, null);
INSERT INTO `horarios` VALUES ('9', '3', '3', '10:00:00', '20:00:00', '2021-12-07 01:07:29', '2021-12-07 01:07:29', '1', '1', null, null);
INSERT INTO `horarios` VALUES ('10', '3', '4', '10:00:00', '20:00:00', '2021-12-07 01:07:29', '2021-12-07 01:07:29', '1', '1', null, null);
INSERT INTO `horarios` VALUES ('11', '3', '5', '10:00:00', '20:00:00', '2021-12-07 01:07:29', '2021-12-07 01:07:29', '1', '1', null, null);
INSERT INTO `horarios` VALUES ('12', '3', '6', '10:00:00', '20:00:00', '2021-12-07 01:07:29', '2021-12-07 01:07:29', '1', '1', null, null);
INSERT INTO `horarios` VALUES ('13', '3', '7', '10:00:00', '20:00:00', '2021-12-07 01:07:29', '2021-12-07 01:07:29', '1', '1', null, null);
INSERT INTO `horarios` VALUES ('14', '3', '1', '10:00:00', '20:00:00', '2021-12-22 01:04:17', '2021-12-22 01:04:17', '1', '1', null, null);
INSERT INTO `horarios` VALUES ('15', '1', '1', '08:00:00', '20:00:00', '2023-11-05 02:00:34', '2023-11-05 02:00:34', '1', '1', '2023-11-05 08:00:34', '2023-11-05 08:00:34');

-- ----------------------------
-- Table structure for ingresos_mercancias
-- ----------------------------
DROP TABLE IF EXISTS `ingresos_mercancias`;
CREATE TABLE `ingresos_mercancias` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `almacen_id` int(11) NOT NULL,
  `producto_id` int(11) NOT NULL,
  `costo` float(9,2) DEFAULT NULL,
  `cantidad` float(9,2) DEFAULT NULL,
  `estatus` varchar(10) NOT NULL DEFAULT 'activo',
  `fecha_registro` datetime NOT NULL DEFAULT current_timestamp(),
  `fecha_modificacion` timestamp NOT NULL DEFAULT current_timestamp(),
  `creado_por` int(11) NOT NULL DEFAULT 1,
  `modificado_por` int(11) NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`),
  KEY `ingresos_mercancias_almacen_id` (`almacen_id`),
  KEY `ingresos_mercancias_producto_id` (`producto_id`),
  CONSTRAINT `ingresos_mercancias_almacen_id` FOREIGN KEY (`almacen_id`) REFERENCES `almacenes` (`id`),
  CONSTRAINT `ingresos_mercancias_producto_id` FOREIGN KEY (`producto_id`) REFERENCES `productos` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- ----------------------------
-- Records of ingresos_mercancias
-- ----------------------------

-- ----------------------------
-- Table structure for inventarios
-- ----------------------------
DROP TABLE IF EXISTS `inventarios`;
CREATE TABLE `inventarios` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `producto_id` int(11) NOT NULL,
  `almacen_id` int(11) NOT NULL,
  `codigo_barras` varchar(45) DEFAULT NULL,
  `nombre` varchar(150) DEFAULT NULL,
  `descripcion` text DEFAULT NULL,
  `precio` float(9,2) DEFAULT NULL,
  `cantidad_existente` double(11,6) NOT NULL DEFAULT 0.000000,
  `cantidad_vendido` double(11,6) NOT NULL DEFAULT 0.000000,
  `estatus` varchar(10) NOT NULL DEFAULT 'activo',
  `fecha_registro` datetime NOT NULL DEFAULT current_timestamp(),
  `fecha_modificacion` timestamp NOT NULL DEFAULT current_timestamp(),
  `creado_por` int(11) NOT NULL DEFAULT 1,
  `modificado_por` int(11) NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`),
  KEY `inventarios_producto_id` (`producto_id`),
  KEY `inventarios_almacen_id` (`almacen_id`),
  CONSTRAINT `inventarios_almacen_id` FOREIGN KEY (`almacen_id`) REFERENCES `almacenes` (`id`),
  CONSTRAINT `inventarios_producto_id` FOREIGN KEY (`producto_id`) REFERENCES `productos` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- ----------------------------
-- Records of inventarios
-- ----------------------------

-- ----------------------------
-- Table structure for marcas
-- ----------------------------
DROP TABLE IF EXISTS `marcas`;
CREATE TABLE `marcas` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `marca` varchar(150) DEFAULT NULL,
  `estatus` varchar(10) NOT NULL DEFAULT 'activo',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- ----------------------------
-- Records of marcas
-- ----------------------------

-- ----------------------------
-- Table structure for migrations
-- ----------------------------
DROP TABLE IF EXISTS `migrations`;
CREATE TABLE `migrations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `migration` varchar(255) NOT NULL,
  `batch` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=117 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ----------------------------
-- Records of migrations
-- ----------------------------
INSERT INTO `migrations` VALUES ('1', '2014_10_12_000000_create_users_table', '1');
INSERT INTO `migrations` VALUES ('2', '2014_10_12_100000_create_password_reset_tokens_table', '1');
INSERT INTO `migrations` VALUES ('3', '2019_08_19_000000_create_failed_jobs_table', '1');
INSERT INTO `migrations` VALUES ('4', '2019_12_14_000001_create_personal_access_tokens_table', '1');
INSERT INTO `migrations` VALUES ('5', '2023_07_17_063714_create_clientes_table', '0');
INSERT INTO `migrations` VALUES ('6', '2023_07_17_063714_create_failed_jobs_table', '0');
INSERT INTO `migrations` VALUES ('7', '2023_07_17_063714_create_horarios_table', '0');
INSERT INTO `migrations` VALUES ('8', '2023_07_17_063714_create_modulos_table', '0');
INSERT INTO `migrations` VALUES ('9', '2023_07_17_063714_create_paneles_table', '0');
INSERT INTO `migrations` VALUES ('10', '2023_07_17_063714_create_password_reset_tokens_table', '0');
INSERT INTO `migrations` VALUES ('11', '2023_07_17_063714_create_personal_access_tokens_table', '0');
INSERT INTO `migrations` VALUES ('12', '2023_07_17_063714_create_sesiones_table', '0');
INSERT INTO `migrations` VALUES ('13', '2023_07_17_063714_create_sesiones_tratamientos_table', '0');
INSERT INTO `migrations` VALUES ('14', '2023_07_17_063714_create_sucursales_table', '0');
INSERT INTO `migrations` VALUES ('15', '2023_07_17_063714_create_sucursales_paneles_table', '0');
INSERT INTO `migrations` VALUES ('16', '2023_07_17_063714_create_tipos_tratamientos_table', '0');
INSERT INTO `migrations` VALUES ('17', '2023_07_17_063714_create_tratamientos_table', '0');
INSERT INTO `migrations` VALUES ('18', '2023_07_17_063714_create_users_table', '0');
INSERT INTO `migrations` VALUES ('19', '2023_07_17_063717_add_foreign_keys_to_horarios_table', '0');
INSERT INTO `migrations` VALUES ('20', '2023_07_17_063717_add_foreign_keys_to_modulos_table', '0');
INSERT INTO `migrations` VALUES ('21', '2023_07_17_063717_add_foreign_keys_to_sesiones_table', '0');
INSERT INTO `migrations` VALUES ('22', '2023_07_17_063717_add_foreign_keys_to_sesiones_tratamientos_table', '0');
INSERT INTO `migrations` VALUES ('23', '2023_07_17_063717_add_foreign_keys_to_sucursales_paneles_table', '0');
INSERT INTO `migrations` VALUES ('24', '2023_07_17_063717_add_foreign_keys_to_tratamientos_table', '0');
INSERT INTO `migrations` VALUES ('25', '2023_07_26_012817_create_clientes_table', '0');
INSERT INTO `migrations` VALUES ('26', '2023_07_26_012817_create_failed_jobs_table', '0');
INSERT INTO `migrations` VALUES ('27', '2023_07_26_012817_create_horarios_table', '0');
INSERT INTO `migrations` VALUES ('28', '2023_07_26_012817_create_modulos_table', '0');
INSERT INTO `migrations` VALUES ('29', '2023_07_26_012817_create_paneles_table', '0');
INSERT INTO `migrations` VALUES ('30', '2023_07_26_012817_create_password_reset_tokens_table', '0');
INSERT INTO `migrations` VALUES ('31', '2023_07_26_012817_create_personal_access_tokens_table', '0');
INSERT INTO `migrations` VALUES ('32', '2023_07_26_012817_create_sesiones_table', '0');
INSERT INTO `migrations` VALUES ('33', '2023_07_26_012817_create_sesiones_tratamientos_table', '0');
INSERT INTO `migrations` VALUES ('34', '2023_07_26_012817_create_sucursales_table', '0');
INSERT INTO `migrations` VALUES ('35', '2023_07_26_012817_create_sucursales_paneles_table', '0');
INSERT INTO `migrations` VALUES ('36', '2023_07_26_012817_create_tipos_tratamientos_table', '0');
INSERT INTO `migrations` VALUES ('37', '2023_07_26_012817_create_tratamientos_table', '0');
INSERT INTO `migrations` VALUES ('38', '2023_07_26_012817_create_users_table', '0');
INSERT INTO `migrations` VALUES ('39', '2023_07_26_012820_add_foreign_keys_to_horarios_table', '0');
INSERT INTO `migrations` VALUES ('40', '2023_07_26_012820_add_foreign_keys_to_modulos_table', '0');
INSERT INTO `migrations` VALUES ('41', '2023_07_26_012820_add_foreign_keys_to_sesiones_table', '0');
INSERT INTO `migrations` VALUES ('42', '2023_07_26_012820_add_foreign_keys_to_sesiones_tratamientos_table', '0');
INSERT INTO `migrations` VALUES ('43', '2023_07_26_012820_add_foreign_keys_to_sucursales_paneles_table', '0');
INSERT INTO `migrations` VALUES ('44', '2023_07_26_012820_add_foreign_keys_to_tratamientos_table', '0');
INSERT INTO `migrations` VALUES ('45', '2023_07_26_033338_create_permission_tables', '2');
INSERT INTO `migrations` VALUES ('46', '2023_07_26_045521_create_clientes_table', '0');
INSERT INTO `migrations` VALUES ('47', '2023_07_26_045521_create_failed_jobs_table', '0');
INSERT INTO `migrations` VALUES ('48', '2023_07_26_045521_create_horarios_table', '0');
INSERT INTO `migrations` VALUES ('49', '2023_07_26_045521_create_model_has_permissions_table', '0');
INSERT INTO `migrations` VALUES ('50', '2023_07_26_045521_create_model_has_roles_table', '0');
INSERT INTO `migrations` VALUES ('51', '2023_07_26_045521_create_modulos_table', '0');
INSERT INTO `migrations` VALUES ('52', '2023_07_26_045521_create_paneles_table', '0');
INSERT INTO `migrations` VALUES ('53', '2023_07_26_045521_create_password_reset_tokens_table', '0');
INSERT INTO `migrations` VALUES ('54', '2023_07_26_045521_create_permissions_table', '0');
INSERT INTO `migrations` VALUES ('55', '2023_07_26_045521_create_personal_access_tokens_table', '0');
INSERT INTO `migrations` VALUES ('56', '2023_07_26_045521_create_role_has_permissions_table', '0');
INSERT INTO `migrations` VALUES ('57', '2023_07_26_045521_create_roles_table', '0');
INSERT INTO `migrations` VALUES ('58', '2023_07_26_045521_create_sesiones_table', '0');
INSERT INTO `migrations` VALUES ('59', '2023_07_26_045521_create_sesiones_tratamientos_table', '0');
INSERT INTO `migrations` VALUES ('60', '2023_07_26_045521_create_sucursales_table', '0');
INSERT INTO `migrations` VALUES ('61', '2023_07_26_045521_create_sucursales_paneles_table', '0');
INSERT INTO `migrations` VALUES ('62', '2023_07_26_045521_create_tipos_tratamientos_table', '0');
INSERT INTO `migrations` VALUES ('63', '2023_07_26_045521_create_tratamientos_table', '0');
INSERT INTO `migrations` VALUES ('64', '2023_07_26_045521_create_users_table', '0');
INSERT INTO `migrations` VALUES ('65', '2023_07_26_045521_create_users_sucursales_table', '0');
INSERT INTO `migrations` VALUES ('66', '2023_07_26_045524_add_foreign_keys_to_horarios_table', '0');
INSERT INTO `migrations` VALUES ('67', '2023_07_26_045524_add_foreign_keys_to_model_has_permissions_table', '0');
INSERT INTO `migrations` VALUES ('68', '2023_07_26_045524_add_foreign_keys_to_model_has_roles_table', '0');
INSERT INTO `migrations` VALUES ('69', '2023_07_26_045524_add_foreign_keys_to_modulos_table', '0');
INSERT INTO `migrations` VALUES ('70', '2023_07_26_045524_add_foreign_keys_to_role_has_permissions_table', '0');
INSERT INTO `migrations` VALUES ('71', '2023_07_26_045524_add_foreign_keys_to_sesiones_table', '0');
INSERT INTO `migrations` VALUES ('72', '2023_07_26_045524_add_foreign_keys_to_sesiones_tratamientos_table', '0');
INSERT INTO `migrations` VALUES ('73', '2023_07_26_045524_add_foreign_keys_to_sucursales_paneles_table', '0');
INSERT INTO `migrations` VALUES ('74', '2023_07_26_045524_add_foreign_keys_to_tratamientos_table', '0');
INSERT INTO `migrations` VALUES ('75', '2023_07_26_045524_add_foreign_keys_to_users_sucursales_table', '0');
INSERT INTO `migrations` VALUES ('76', '2023_07_26_072223_create_almacenes_table', '0');
INSERT INTO `migrations` VALUES ('77', '2023_07_26_072223_create_clientes_table', '0');
INSERT INTO `migrations` VALUES ('78', '2023_07_26_072223_create_expedientes_table', '0');
INSERT INTO `migrations` VALUES ('79', '2023_07_26_072223_create_failed_jobs_table', '0');
INSERT INTO `migrations` VALUES ('80', '2023_07_26_072223_create_horarios_table', '0');
INSERT INTO `migrations` VALUES ('81', '2023_07_26_072223_create_inventarios_table', '0');
INSERT INTO `migrations` VALUES ('82', '2023_07_26_072223_create_marcas_table', '0');
INSERT INTO `migrations` VALUES ('83', '2023_07_26_072223_create_model_has_permissions_table', '0');
INSERT INTO `migrations` VALUES ('84', '2023_07_26_072223_create_model_has_roles_table', '0');
INSERT INTO `migrations` VALUES ('85', '2023_07_26_072223_create_modulos_table', '0');
INSERT INTO `migrations` VALUES ('86', '2023_07_26_072223_create_paneles_table', '0');
INSERT INTO `migrations` VALUES ('87', '2023_07_26_072223_create_password_reset_tokens_table', '0');
INSERT INTO `migrations` VALUES ('88', '2023_07_26_072223_create_permissions_table', '0');
INSERT INTO `migrations` VALUES ('89', '2023_07_26_072223_create_personal_access_tokens_table', '0');
INSERT INTO `migrations` VALUES ('90', '2023_07_26_072223_create_productos_table', '0');
INSERT INTO `migrations` VALUES ('91', '2023_07_26_072223_create_role_has_permissions_table', '0');
INSERT INTO `migrations` VALUES ('92', '2023_07_26_072223_create_roles_table', '0');
INSERT INTO `migrations` VALUES ('93', '2023_07_26_072223_create_sesiones_table', '0');
INSERT INTO `migrations` VALUES ('94', '2023_07_26_072223_create_sesiones_tratamientos_table', '0');
INSERT INTO `migrations` VALUES ('95', '2023_07_26_072223_create_sucursales_table', '0');
INSERT INTO `migrations` VALUES ('96', '2023_07_26_072223_create_sucursales_paneles_table', '0');
INSERT INTO `migrations` VALUES ('97', '2023_07_26_072223_create_tipos_tratamientos_table', '0');
INSERT INTO `migrations` VALUES ('98', '2023_07_26_072223_create_tratamientos_table', '0');
INSERT INTO `migrations` VALUES ('99', '2023_07_26_072223_create_users_table', '0');
INSERT INTO `migrations` VALUES ('100', '2023_07_26_072223_create_users_sucursales_table', '0');
INSERT INTO `migrations` VALUES ('101', '2023_07_26_072226_add_foreign_keys_to_almacenes_table', '0');
INSERT INTO `migrations` VALUES ('102', '2023_07_26_072226_add_foreign_keys_to_expedientes_table', '0');
INSERT INTO `migrations` VALUES ('103', '2023_07_26_072226_add_foreign_keys_to_horarios_table', '0');
INSERT INTO `migrations` VALUES ('104', '2023_07_26_072226_add_foreign_keys_to_inventarios_table', '0');
INSERT INTO `migrations` VALUES ('105', '2023_07_26_072226_add_foreign_keys_to_model_has_permissions_table', '0');
INSERT INTO `migrations` VALUES ('106', '2023_07_26_072226_add_foreign_keys_to_model_has_roles_table', '0');
INSERT INTO `migrations` VALUES ('107', '2023_07_26_072226_add_foreign_keys_to_modulos_table', '0');
INSERT INTO `migrations` VALUES ('108', '2023_07_26_072226_add_foreign_keys_to_productos_table', '0');
INSERT INTO `migrations` VALUES ('109', '2023_07_26_072226_add_foreign_keys_to_role_has_permissions_table', '0');
INSERT INTO `migrations` VALUES ('110', '2023_07_26_072226_add_foreign_keys_to_sesiones_table', '0');
INSERT INTO `migrations` VALUES ('111', '2023_07_26_072226_add_foreign_keys_to_sesiones_tratamientos_table', '0');
INSERT INTO `migrations` VALUES ('112', '2023_07_26_072226_add_foreign_keys_to_sucursales_paneles_table', '0');
INSERT INTO `migrations` VALUES ('113', '2023_07_26_072226_add_foreign_keys_to_tratamientos_table', '0');
INSERT INTO `migrations` VALUES ('114', '2023_07_26_072226_add_foreign_keys_to_users_sucursales_table', '0');
INSERT INTO `migrations` VALUES ('115', '2014_10_12_100000_create_password_resets_table', '3');
INSERT INTO `migrations` VALUES ('116', '2023_11_06_083819_create_permission_tables', '4');

-- ----------------------------
-- Table structure for model_has_permissions
-- ----------------------------
DROP TABLE IF EXISTS `model_has_permissions`;
CREATE TABLE `model_has_permissions` (
  `permission_id` bigint(20) unsigned NOT NULL,
  `model_type` varchar(255) NOT NULL,
  `model_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`permission_id`,`model_id`,`model_type`),
  KEY `model_has_permissions_model_id_model_type_index` (`model_id`,`model_type`),
  CONSTRAINT `model_has_permissions_permission_id_foreign` FOREIGN KEY (`permission_id`) REFERENCES `permissions` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ----------------------------
-- Records of model_has_permissions
-- ----------------------------

-- ----------------------------
-- Table structure for model_has_roles
-- ----------------------------
DROP TABLE IF EXISTS `model_has_roles`;
CREATE TABLE `model_has_roles` (
  `role_id` bigint(20) unsigned NOT NULL,
  `model_type` varchar(255) NOT NULL,
  `model_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`role_id`,`model_id`,`model_type`),
  KEY `model_has_roles_model_id_model_type_index` (`model_id`,`model_type`),
  CONSTRAINT `model_has_roles_role_id_foreign` FOREIGN KEY (`role_id`) REFERENCES `roles` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ----------------------------
-- Records of model_has_roles
-- ----------------------------
INSERT INTO `model_has_roles` VALUES ('1', 'App\\Models\\User', '1');
INSERT INTO `model_has_roles` VALUES ('1', 'App\\Models\\User', '2');
INSERT INTO `model_has_roles` VALUES ('1', 'App\\Models\\User', '23');
INSERT INTO `model_has_roles` VALUES ('1', 'App\\Models\\User', '24');
INSERT INTO `model_has_roles` VALUES ('1', 'App\\Models\\User', '25');
INSERT INTO `model_has_roles` VALUES ('1', 'App\\Models\\User', '37');
INSERT INTO `model_has_roles` VALUES ('1', 'App\\Models\\User', '38');
INSERT INTO `model_has_roles` VALUES ('2', 'App\\Models\\User', '10');
INSERT INTO `model_has_roles` VALUES ('2', 'App\\Models\\User', '13');
INSERT INTO `model_has_roles` VALUES ('2', 'App\\Models\\User', '14');
INSERT INTO `model_has_roles` VALUES ('2', 'App\\Models\\User', '15');
INSERT INTO `model_has_roles` VALUES ('2', 'App\\Models\\User', '16');
INSERT INTO `model_has_roles` VALUES ('2', 'App\\Models\\User', '17');
INSERT INTO `model_has_roles` VALUES ('2', 'App\\Models\\User', '18');
INSERT INTO `model_has_roles` VALUES ('2', 'App\\Models\\User', '21');
INSERT INTO `model_has_roles` VALUES ('2', 'App\\Models\\User', '28');
INSERT INTO `model_has_roles` VALUES ('2', 'App\\Models\\User', '34');
INSERT INTO `model_has_roles` VALUES ('2', 'App\\Models\\User', '35');
INSERT INTO `model_has_roles` VALUES ('2', 'App\\Models\\User', '36');
INSERT INTO `model_has_roles` VALUES ('2', 'App\\Models\\User', '39');
INSERT INTO `model_has_roles` VALUES ('2', 'App\\Models\\User', '40');
INSERT INTO `model_has_roles` VALUES ('2', 'App\\Models\\User', '41');
INSERT INTO `model_has_roles` VALUES ('2', 'App\\Models\\User', '42');
INSERT INTO `model_has_roles` VALUES ('2', 'App\\Models\\User', '43');
INSERT INTO `model_has_roles` VALUES ('3', 'App\\Models\\User', '44');

-- ----------------------------
-- Table structure for modulos
-- ----------------------------
DROP TABLE IF EXISTS `modulos`;
CREATE TABLE `modulos` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `clave` varchar(255) NOT NULL,
  `modulo` text NOT NULL,
  `habilitado` varchar(10) NOT NULL DEFAULT 'activo',
  `panel_id` int(11) NOT NULL,
  `fecha_registro` datetime NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `fecha_modificacion` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `creado_por` int(11) NOT NULL DEFAULT 1,
  `modificado_por` int(11) NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`),
  KEY `modulos_panel_id` (`panel_id`),
  CONSTRAINT `modulos_panel_id` FOREIGN KEY (`panel_id`) REFERENCES `paneles` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- ----------------------------
-- Records of modulos
-- ----------------------------

-- ----------------------------
-- Table structure for opciones
-- ----------------------------
DROP TABLE IF EXISTS `opciones`;
CREATE TABLE `opciones` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `descripcion` text NOT NULL,
  `pregunta_id` int(11) NOT NULL,
  `estatus` varchar(10) NOT NULL DEFAULT 'activo',
  `orden` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `opciones_pregunta_id` (`pregunta_id`),
  CONSTRAINT `opciones_pregunta_id` FOREIGN KEY (`pregunta_id`) REFERENCES `preguntas` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- ----------------------------
-- Records of opciones
-- ----------------------------

-- ----------------------------
-- Table structure for pagos
-- ----------------------------
DROP TABLE IF EXISTS `pagos`;
CREATE TABLE `pagos` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `venta_id` bigint(20) unsigned NOT NULL,
  `banco` varchar(100) DEFAULT NULL,
  `folio_pago` varchar(255) DEFAULT NULL,
  `tipo_pago_id` int(11) NOT NULL,
  `total` double(11,6) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `pagos_venta_id` (`venta_id`),
  KEY `pagos_tipo_pago_id` (`tipo_pago_id`),
  CONSTRAINT `pagos_tipo_pago_id` FOREIGN KEY (`tipo_pago_id`) REFERENCES `tipos_pagos` (`id`),
  CONSTRAINT `pagos_venta_id` FOREIGN KEY (`venta_id`) REFERENCES `ventas` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- ----------------------------
-- Records of pagos
-- ----------------------------

-- ----------------------------
-- Table structure for paneles
-- ----------------------------
DROP TABLE IF EXISTS `paneles`;
CREATE TABLE `paneles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `clave` varchar(255) NOT NULL,
  `panel` text NOT NULL,
  `habilitado` varchar(10) NOT NULL DEFAULT 'activo',
  `fecha_registro` datetime NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `fecha_modificacion` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `creado_por` int(11) NOT NULL DEFAULT 1,
  `modificado_por` int(11) NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- ----------------------------
-- Records of paneles
-- ----------------------------

-- ----------------------------
-- Table structure for password_resets
-- ----------------------------
DROP TABLE IF EXISTS `password_resets`;
CREATE TABLE `password_resets` (
  `email` varchar(255) NOT NULL,
  `token` varchar(255) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  KEY `password_resets_email_index` (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ----------------------------
-- Records of password_resets
-- ----------------------------

-- ----------------------------
-- Table structure for password_reset_tokens
-- ----------------------------
DROP TABLE IF EXISTS `password_reset_tokens`;
CREATE TABLE `password_reset_tokens` (
  `email` varchar(255) NOT NULL,
  `token` varchar(255) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ----------------------------
-- Records of password_reset_tokens
-- ----------------------------

-- ----------------------------
-- Table structure for permissions
-- ----------------------------
DROP TABLE IF EXISTS `permissions`;
CREATE TABLE `permissions` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `guard_name` varchar(255) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `permissions_name_guard_name_unique` (`name`,`guard_name`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ----------------------------
-- Records of permissions
-- ----------------------------
INSERT INTO `permissions` VALUES ('1', 'can-view-use', 'web', '2023-11-07 09:27:36', '2023-11-07 09:27:36');

-- ----------------------------
-- Table structure for personal_access_tokens
-- ----------------------------
DROP TABLE IF EXISTS `personal_access_tokens`;
CREATE TABLE `personal_access_tokens` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `tokenable_type` varchar(255) NOT NULL,
  `tokenable_id` bigint(20) unsigned NOT NULL,
  `name` varchar(255) NOT NULL,
  `token` varchar(64) NOT NULL,
  `abilities` text DEFAULT NULL,
  `last_used_at` timestamp NULL DEFAULT NULL,
  `expires_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `personal_access_tokens_token_unique` (`token`),
  KEY `personal_access_tokens_tokenable_type_tokenable_id_index` (`tokenable_type`,`tokenable_id`)
) ENGINE=InnoDB AUTO_INCREMENT=55 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ----------------------------
-- Records of personal_access_tokens
-- ----------------------------
INSERT INTO `personal_access_tokens` VALUES ('1', 'App\\Models\\User', '1', 'Deyvi Jesus Gomez Moha', '51f4fe74c990d7ec6c73aa8da998e0bd2db4961121c4fefd68c4573f4b34d8a1', '[\"*\"]', null, null, '2023-08-31 03:24:19', '2023-08-31 03:24:19');
INSERT INTO `personal_access_tokens` VALUES ('2', 'App\\Models\\User', '1', 'Deyvi Jesus Gomez Moha', '2f47f5d3674eeb020764d3ddabf7d81afc429115ffac9e446dd3779040b48260', '[\"*\"]', null, null, '2023-08-31 03:39:04', '2023-08-31 03:39:04');
INSERT INTO `personal_access_tokens` VALUES ('3', 'App\\Models\\User', '1', 'Deyvi Jesus Gomez Moha', '0f71c238b9b5811c4480746a7ab1d1bb8fa33ab3b292e35ab907ea24d0953e42', '[\"*\"]', null, null, '2023-08-31 04:24:04', '2023-08-31 04:24:04');
INSERT INTO `personal_access_tokens` VALUES ('4', 'App\\Models\\User', '1', 'Deyvi Jesus Gomez Moha', '3af4e77554dcf77f842a49181cd247aae795ba2c912b078f95c816ec755c0fd8', '[\"*\"]', null, null, '2023-08-31 04:28:17', '2023-08-31 04:28:17');
INSERT INTO `personal_access_tokens` VALUES ('5', 'App\\Models\\User', '1', 'Deyvi Jesus Gomez Moha', '2d2533b2b00df49affdda21bfb48eaa6d48ca3417473002af72e9127c428afdc', '[\"*\"]', null, null, '2023-08-31 04:28:51', '2023-08-31 04:28:51');
INSERT INTO `personal_access_tokens` VALUES ('6', 'App\\Models\\User', '1', 'Deyvi Jesus Gomez Moha', 'f7d498511f56668692758a0d1b742d3a19c5cd55abe6c6f4891775b08111ff03', '[\"*\"]', null, null, '2023-08-31 04:30:17', '2023-08-31 04:30:17');
INSERT INTO `personal_access_tokens` VALUES ('7', 'App\\Models\\User', '1', 'Deyvi Jesus Gomez Moha', 'b6f0150a38349c104a8655eaa8a3e16b19ba4abed60e7dfa0373034148cc711b', '[\"*\"]', null, null, '2023-08-31 04:33:09', '2023-08-31 04:33:09');
INSERT INTO `personal_access_tokens` VALUES ('8', 'App\\Models\\User', '1', 'Deyvi Jesus Gomez Moha', 'c6c3dadd3a2248ec54b997d30f353730569dedc602cd0241d50f3aa1c53d6eb4', '[\"*\"]', null, null, '2023-08-31 04:37:58', '2023-08-31 04:37:58');
INSERT INTO `personal_access_tokens` VALUES ('9', 'App\\Models\\User', '1', 'Deyvi Jesus Gomez Moha', '7de54322d95ce8d5feabfdb6fe831a2384e6a92b89fe6cb7f13982fac59d8fd1', '[\"*\"]', null, null, '2023-08-31 04:41:34', '2023-08-31 04:41:34');
INSERT INTO `personal_access_tokens` VALUES ('10', 'App\\Models\\User', '1', 'Deyvi Jesus Gomez Moha', '08f3f783028adffc92aeb42bf69b966593f11b154f6766d2043314ec3a7a6903', '[\"*\"]', null, null, '2023-08-31 04:42:59', '2023-08-31 04:42:59');
INSERT INTO `personal_access_tokens` VALUES ('11', 'App\\Models\\User', '1', 'Deyvi Jesus Gomez Moha', '52642311132825bc2b993c0a5f53fcca8ac99e2767e38075a9841c090c063013', '[\"*\"]', '2023-09-01 04:09:15', null, '2023-08-31 04:48:32', '2023-09-01 04:09:15');
INSERT INTO `personal_access_tokens` VALUES ('12', 'App\\Models\\User', '1', 'Deyvi Jesus Gomez Moha', 'b0642288bdde92e20e26a99ff4903fccfb8ca7b2d1cb73592228978896e583fe', '[\"*\"]', '2023-09-02 17:24:39', null, '2023-09-01 04:27:30', '2023-09-02 17:24:39');
INSERT INTO `personal_access_tokens` VALUES ('13', 'App\\Models\\User', '1', 'Deyvi Jesus Gomez Moha', '61a2b846384bfb2ea8991e847a4d45bcd804ea909e4e2c9f0d0551b7ef77694f', '[\"*\"]', '2023-09-02 17:34:59', null, '2023-09-02 17:26:18', '2023-09-02 17:34:59');
INSERT INTO `personal_access_tokens` VALUES ('14', 'App\\Models\\User', '1', 'Deyvi Jesus Gomez Moha', '644340779c23cdec4ef0e6890e958e230f950579f2aefa6ad4a669b1642a3eff', '[\"*\"]', '2023-09-02 20:29:05', null, '2023-09-02 17:35:35', '2023-09-02 20:29:05');
INSERT INTO `personal_access_tokens` VALUES ('15', 'App\\Models\\User', '1', 'Deyvi Jesus Gomez Moha', 'dc78623e39393e16f5d5d996664239cf0bf1281e333127255d6b74aa23fde69a', '[\"*\"]', '2023-09-04 04:43:08', null, '2023-09-02 20:29:58', '2023-09-04 04:43:08');
INSERT INTO `personal_access_tokens` VALUES ('16', 'App\\Models\\User', '2', 'Administrador', 'f05741db5644998e0a9905f752dca623163609f5d079d5828896ec3fae052de5', '[\"*\"]', '2023-09-06 06:47:37', null, '2023-09-04 04:56:28', '2023-09-06 06:47:37');
INSERT INTO `personal_access_tokens` VALUES ('17', 'App\\Models\\User', '2', 'Administrador', 'be60de9d26a6ae6839fd1cce267d9c4b2a7bb394c31e06a813a8fbd6f1945dd7', '[\"*\"]', '2023-09-04 13:26:47', null, '2023-09-04 13:16:19', '2023-09-04 13:26:47');
INSERT INTO `personal_access_tokens` VALUES ('18', 'App\\Models\\User', '2', 'Administrador', '4916d80d09afe7327870943dba6254d56aa528594c4126e24fe5c44d98a4cd83', '[\"*\"]', '2023-09-04 14:40:10', null, '2023-09-04 13:33:17', '2023-09-04 14:40:10');
INSERT INTO `personal_access_tokens` VALUES ('19', 'App\\Models\\User', '2', 'Administrador', '72cc34f37f7429351944b60a32064f56819da955a507bce64e0ea08b133a71c9', '[\"*\"]', '2023-09-10 18:13:55', null, '2023-09-06 06:48:26', '2023-09-10 18:13:55');
INSERT INTO `personal_access_tokens` VALUES ('20', 'App\\Models\\User', '2', 'Administrador', 'abfce955ce90cf7f02fc379d2445c013626f5ba6fafac5d3757adc6f8434c38f', '[\"*\"]', '2023-10-06 06:36:17', null, '2023-09-10 20:51:56', '2023-10-06 06:36:17');
INSERT INTO `personal_access_tokens` VALUES ('21', 'App\\Models\\User', '2', 'Administrador', '861d6e6d3da8cb3bad148d8081f01d6e9cef037e56711f8895053d2eab1b521a', '[\"*\"]', '2023-10-23 07:20:04', null, '2023-10-06 07:49:03', '2023-10-23 07:20:04');
INSERT INTO `personal_access_tokens` VALUES ('22', 'App\\Models\\User', '2', 'Administrador', 'd898043927bb34da64890a2888368d7629676a43455a784f56071b4e27db9111', '[\"*\"]', '2023-10-18 06:31:52', null, '2023-10-18 06:31:31', '2023-10-18 06:31:52');
INSERT INTO `personal_access_tokens` VALUES ('23', 'App\\Models\\User', '2', 'Administrador', '8b8552003d74b46e41f6e4cec1be04bef8cb16b9986a4cae7825ffd3333ca3a1', '[\"*\"]', '2023-10-23 07:28:34', null, '2023-10-23 07:27:14', '2023-10-23 07:28:34');
INSERT INTO `personal_access_tokens` VALUES ('24', 'App\\Models\\User', '2', 'Administrador', 'd999bfc616a8d6ebf7e73077b34fe72116e007566b7eb950c57e8b16ca71b6fb', '[\"*\"]', '2023-11-06 09:10:16', null, '2023-10-23 07:34:44', '2023-11-06 09:10:16');
INSERT INTO `personal_access_tokens` VALUES ('25', 'App\\Models\\User', '2', 'Administrador', '7cf320649f9b9e07b37e5ae904a2fe03e070a744c632bd5818e8b354b3e2175e', '[\"*\"]', '2023-11-07 09:01:32', null, '2023-11-06 09:15:02', '2023-11-07 09:01:32');
INSERT INTO `personal_access_tokens` VALUES ('26', 'App\\Models\\User', '2', 'Administrador', 'e7e9a91dc0f43e9c8d7a06ecdfbcd79beb543d08527ed2c1214ea07133025eef', '[\"*\"]', '2023-11-12 06:33:25', null, '2023-11-07 09:01:52', '2023-11-12 06:33:25');
INSERT INTO `personal_access_tokens` VALUES ('27', 'App\\Models\\User', '2', 'Administrador', '52445aae0303ec9420681e75d6fd51fb19166df34da74bf93f9289aa59adf813', '[\"*\"]', '2023-11-12 07:05:07', null, '2023-11-12 07:03:54', '2023-11-12 07:05:07');
INSERT INTO `personal_access_tokens` VALUES ('28', 'App\\Models\\User', '2', 'Administrador', 'b73a31acdbe1d7852884fe6bd2e2243438f7fc690d2ac4a67b461c5011a400d9', '[\"*\"]', '2023-11-26 17:57:48', null, '2023-11-12 07:06:24', '2023-11-26 17:57:48');
INSERT INTO `personal_access_tokens` VALUES ('29', 'App\\Models\\User', '2', 'Administrador', 'd8fd7d76ee16793c2fa224ca1ca46af44e7a2bb7b09219f0690dde3260cfd387', '[\"*\"]', '2023-11-27 05:01:39', null, '2023-11-27 00:28:52', '2023-11-27 05:01:39');
INSERT INTO `personal_access_tokens` VALUES ('30', 'App\\Models\\User', '48', 'pr', '43d165bc588889b5b7e061be1265acfa3e087afee3a15a87cb2bb9bf393f5634', '[\"*\"]', '2023-12-01 07:59:07', null, '2023-12-01 07:57:11', '2023-12-01 07:59:07');
INSERT INTO `personal_access_tokens` VALUES ('31', 'App\\Models\\User', '2', 'Administrador', 'f78e895be78d535f4ae1adee1940f2d5edda1dafdcd30115761ac66883da34d4', '[\"*\"]', '2023-12-02 14:03:13', null, '2023-12-02 07:25:00', '2023-12-02 14:03:13');
INSERT INTO `personal_access_tokens` VALUES ('32', 'App\\Models\\User', '15', 'MARY', 'c088e58617d695599b17243deda0e3b60ae5e1579d12329b9100eb054a0f16bb', '[\"*\"]', '2023-12-02 14:11:13', null, '2023-12-02 14:05:29', '2023-12-02 14:11:13');
INSERT INTO `personal_access_tokens` VALUES ('33', 'App\\Models\\User', '47', 'prueba', '7d2e02de272b6ff897ba471c4be664b5f7331511f79253091f370d39a25d4ac6', '[\"*\"]', '2023-12-02 16:02:30', null, '2023-12-02 14:30:21', '2023-12-02 16:02:30');
INSERT INTO `personal_access_tokens` VALUES ('34', 'App\\Models\\User', '2', 'Administrador', 'dd68b8dfafe71b4b08f195c8429977e3aec2de6b7cf02846d86649f03898af60', '[\"*\"]', '2023-12-04 04:13:39', null, '2023-12-02 16:02:57', '2023-12-04 04:13:39');
INSERT INTO `personal_access_tokens` VALUES ('35', 'App\\Models\\User', '47', 'prueba', '8d8cfc48dee9794edce9cf4340d3b9853754023ba01998c79c2aa4d5eba68de3', '[\"*\"]', '2023-12-03 16:38:17', null, '2023-12-02 17:18:07', '2023-12-03 16:38:17');
INSERT INTO `personal_access_tokens` VALUES ('36', 'App\\Models\\User', '47', 'prueba', 'a31a6ee3cefb96306b7be123d686eedfff454e706816efc45867498c3b020626', '[\"*\"]', '2023-12-04 03:30:27', null, '2023-12-03 23:02:03', '2023-12-04 03:30:27');
INSERT INTO `personal_access_tokens` VALUES ('37', 'App\\Models\\User', '47', 'prueba', '5aa2512bfa8fe089c8be93e06d2cf0d3eee4d81dc907ef4c871e1c23ed23ae51', '[\"*\"]', '2023-12-04 04:31:12', null, '2023-12-04 04:16:50', '2023-12-04 04:31:12');
INSERT INTO `personal_access_tokens` VALUES ('38', 'App\\Models\\User', '47', 'prueba', '3fdbbeb42e6c24d045b3e41cc0d5dd2c1c5a0b3d24c48154f23095896975b25a', '[\"*\"]', '2023-12-04 04:36:55', null, '2023-12-04 04:33:43', '2023-12-04 04:36:55');
INSERT INTO `personal_access_tokens` VALUES ('39', 'App\\Models\\User', '47', 'prueba', '9b8acd0fdcfb3321454c765dfd2c7e231a789acfdc5e5a10e1553ec99f2c7c37', '[\"*\"]', '2023-12-04 04:51:13', null, '2023-12-04 04:47:58', '2023-12-04 04:51:13');
INSERT INTO `personal_access_tokens` VALUES ('40', 'App\\Models\\User', '47', 'prueba', '3fd88349b6f22614b981b77fc94dd25a8d6ebeb8fed3c31a096027094315f081', '[\"*\"]', null, null, '2023-12-04 04:52:33', '2023-12-04 04:52:33');
INSERT INTO `personal_access_tokens` VALUES ('41', 'App\\Models\\User', '47', 'prueba', '47c09640894f6e27c5ccbb6a823fecab0c63b2cd1ffc3927116af9e1f83045c6', '[\"*\"]', '2023-12-04 05:49:11', null, '2023-12-04 05:47:52', '2023-12-04 05:49:11');
INSERT INTO `personal_access_tokens` VALUES ('42', 'App\\Models\\User', '47', 'prueba', '36b334c530fcd6ea8ae74666c7dfe1118583c3e5e9c39a1646fd742cbf332aaa', '[\"*\"]', '2023-12-04 06:06:57', null, '2023-12-04 05:52:32', '2023-12-04 06:06:57');
INSERT INTO `personal_access_tokens` VALUES ('43', 'App\\Models\\User', '47', 'prueba', 'cfe8f5c9ba091c7912a2b35a76288dfa86cc2e212b73145548f8d38c7e444611', '[\"*\"]', '2023-12-04 06:38:32', null, '2023-12-04 06:36:27', '2023-12-04 06:38:32');
INSERT INTO `personal_access_tokens` VALUES ('44', 'App\\Models\\User', '47', 'prueba', '6ba0b08cee0929f5a2b797c4abb1c1b14d10cc497ccdc56b5f6bf49d7b0db292', '[\"*\"]', '2023-12-04 06:43:20', null, '2023-12-04 06:40:13', '2023-12-04 06:43:20');
INSERT INTO `personal_access_tokens` VALUES ('45', 'App\\Models\\User', '47', 'prueba', '4f0c93783d64cfc5634d54415fdeb0cc23ea61d57759bba0258a6376bedc7e2b', '[\"*\"]', '2023-12-04 06:45:58', null, '2023-12-04 06:43:44', '2023-12-04 06:45:58');
INSERT INTO `personal_access_tokens` VALUES ('46', 'App\\Models\\User', '47', 'prueba', 'bd8291cf6c07057c51c8cd8c2253449e9a156bc965a514723e956cb8429559ad', '[\"*\"]', '2023-12-04 06:48:32', null, '2023-12-04 06:47:06', '2023-12-04 06:48:32');
INSERT INTO `personal_access_tokens` VALUES ('47', 'App\\Models\\User', '47', 'prueba', 'ff674083ee2d751318aaaa90f03d4e6f302f7bc67c7573f41dc5df4853afef61', '[\"*\"]', '2023-12-04 06:49:47', null, '2023-12-04 06:49:13', '2023-12-04 06:49:47');
INSERT INTO `personal_access_tokens` VALUES ('48', 'App\\Models\\User', '47', 'prueba', '783eae691861be0d6254a1460cc2a0f2144d2b5f4650338df2467eb37c589de8', '[\"*\"]', '2023-12-04 07:08:07', null, '2023-12-04 06:52:54', '2023-12-04 07:08:07');
INSERT INTO `personal_access_tokens` VALUES ('49', 'App\\Models\\User', '47', 'prueba', '632b7b006e422cc10eaf880c393a134f9a27396ced06fb205029fd41e6e23088', '[\"*\"]', '2023-12-04 07:11:03', null, '2023-12-04 07:09:19', '2023-12-04 07:11:03');
INSERT INTO `personal_access_tokens` VALUES ('50', 'App\\Models\\User', '47', 'prueba', '0912aa447552b99cf80486ff1d97790805638a94e891c65dca670c542299ffcc', '[\"*\"]', '2023-12-04 07:12:36', null, '2023-12-04 07:11:44', '2023-12-04 07:12:36');
INSERT INTO `personal_access_tokens` VALUES ('51', 'App\\Models\\User', '47', 'prueba', 'a130339e66744480ab4a3a78bee300e742d65d1e6e580b5a2cbdefc9d08eb0e5', '[\"*\"]', '2023-12-04 07:20:40', null, '2023-12-04 07:14:28', '2023-12-04 07:20:40');
INSERT INTO `personal_access_tokens` VALUES ('52', 'App\\Models\\User', '47', 'prueba', '2e09dbe9328c6409febde2b332ac5d6567053600d25575448d87991904cfc9b7', '[\"*\"]', '2023-12-04 07:23:20', null, '2023-12-04 07:22:44', '2023-12-04 07:23:20');
INSERT INTO `personal_access_tokens` VALUES ('53', 'App\\Models\\User', '47', 'prueba', '26b6a78b62407de13dc8f6c3017150d0f0269c11313c21a015d856800bcf0227', '[\"*\"]', '2023-12-09 03:15:29', null, '2023-12-04 07:25:06', '2023-12-09 03:15:29');
INSERT INTO `personal_access_tokens` VALUES ('54', 'App\\Models\\User', '2', 'Administrador', '10476aee039686ecf6fc88d134f12ba7a9d9c92d1352d953be607afc4b34bf13', '[\"*\"]', '2023-12-09 05:54:29', null, '2023-12-04 08:40:01', '2023-12-09 05:54:29');

-- ----------------------------
-- Table structure for preguntas
-- ----------------------------
DROP TABLE IF EXISTS `preguntas`;
CREATE TABLE `preguntas` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `encuesta_id` int(11) NOT NULL,
  `descripcion` text NOT NULL,
  `estatus` varchar(10) NOT NULL DEFAULT 'activo',
  `orden` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `preguntas_encuesta_id` (`encuesta_id`),
  CONSTRAINT `preguntas_encuesta_id` FOREIGN KEY (`encuesta_id`) REFERENCES `encuestas` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- ----------------------------
-- Records of preguntas
-- ----------------------------

-- ----------------------------
-- Table structure for productos
-- ----------------------------
DROP TABLE IF EXISTS `productos`;
CREATE TABLE `productos` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `marca_id` int(11) DEFAULT NULL,
  `codigo_barras` varchar(45) DEFAULT '',
  `nombre` varchar(150) DEFAULT NULL,
  `descripcion` text DEFAULT NULL,
  `precio` float(9,2) DEFAULT NULL,
  `tiene_iva` varchar(4) NOT NULL DEFAULT 'si',
  `iva` decimal(2,2) NOT NULL DEFAULT 0.00,
  `tiene_ieps` varchar(4) NOT NULL DEFAULT 'no',
  `ieps` decimal(2,2) NOT NULL,
  `estatus` varchar(10) NOT NULL DEFAULT 'activo',
  `fecha_registro` datetime NOT NULL DEFAULT current_timestamp(),
  `fecha_modificacion` timestamp NOT NULL DEFAULT current_timestamp(),
  `creado_por` int(11) NOT NULL DEFAULT 1,
  `modificado_por` int(11) NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`),
  KEY `productos_marca_id` (`marca_id`),
  CONSTRAINT `productos_marca_id` FOREIGN KEY (`marca_id`) REFERENCES `marcas` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- ----------------------------
-- Records of productos
-- ----------------------------

-- ----------------------------
-- Table structure for productos_bajas
-- ----------------------------
DROP TABLE IF EXISTS `productos_bajas`;
CREATE TABLE `productos_bajas` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `tipo_baja_id` int(11) NOT NULL,
  `almacen_id` int(11) NOT NULL,
  `producto_id` int(11) NOT NULL,
  `cantidad` float(9,2) DEFAULT NULL,
  `observacion` text DEFAULT NULL,
  `estatus` varchar(10) NOT NULL DEFAULT 'activo',
  `fecha_registro` datetime NOT NULL DEFAULT current_timestamp(),
  `fecha_modificacion` timestamp NOT NULL DEFAULT current_timestamp(),
  `creado_por` int(11) NOT NULL DEFAULT 1,
  `modificado_por` int(11) NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`),
  KEY `productos_bajas_tipo_baja_id` (`tipo_baja_id`),
  KEY `productos_bajas_almacen_id` (`almacen_id`),
  KEY `productos_bajas_producto_id` (`producto_id`),
  CONSTRAINT `productos_bajas_almacen_id` FOREIGN KEY (`almacen_id`) REFERENCES `almacenes` (`id`),
  CONSTRAINT `productos_bajas_producto_id` FOREIGN KEY (`producto_id`) REFERENCES `productos` (`id`),
  CONSTRAINT `productos_bajas_tipo_baja_id` FOREIGN KEY (`tipo_baja_id`) REFERENCES `tipos_bajas` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- ----------------------------
-- Records of productos_bajas
-- ----------------------------

-- ----------------------------
-- Table structure for respuestas
-- ----------------------------
DROP TABLE IF EXISTS `respuestas`;
CREATE TABLE `respuestas` (
  `id` int(11) NOT NULL,
  `opcion_id` int(11) NOT NULL,
  `cliente_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `respuestas_opcion_id` (`opcion_id`),
  KEY `respuestas_cliente_id` (`cliente_id`),
  CONSTRAINT `respuestas_cliente_id` FOREIGN KEY (`cliente_id`) REFERENCES `clientes` (`id`),
  CONSTRAINT `respuestas_opcion_id` FOREIGN KEY (`opcion_id`) REFERENCES `opciones` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- ----------------------------
-- Records of respuestas
-- ----------------------------

-- ----------------------------
-- Table structure for roles
-- ----------------------------
DROP TABLE IF EXISTS `roles`;
CREATE TABLE `roles` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `guard_name` varchar(255) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `roles_name_guard_name_unique` (`name`,`guard_name`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ----------------------------
-- Records of roles
-- ----------------------------
INSERT INTO `roles` VALUES ('1', 'Administrador', 'web', '2023-11-07 08:16:21', '2023-11-07 08:16:21');
INSERT INTO `roles` VALUES ('2', 'Terapista', 'web', '2023-11-07 09:45:12', '2023-11-07 09:45:12');
INSERT INTO `roles` VALUES ('3', 'Cliente', 'web', '2023-11-09 03:19:05', '2023-11-09 03:19:05');
INSERT INTO `roles` VALUES ('4', 'Venta', 'web', '2023-11-09 03:20:59', '2023-11-09 03:20:59');

-- ----------------------------
-- Table structure for role_has_permissions
-- ----------------------------
DROP TABLE IF EXISTS `role_has_permissions`;
CREATE TABLE `role_has_permissions` (
  `permission_id` bigint(20) unsigned NOT NULL,
  `role_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`permission_id`,`role_id`),
  KEY `role_has_permissions_role_id_foreign` (`role_id`),
  CONSTRAINT `role_has_permissions_permission_id_foreign` FOREIGN KEY (`permission_id`) REFERENCES `permissions` (`id`) ON DELETE CASCADE,
  CONSTRAINT `role_has_permissions_role_id_foreign` FOREIGN KEY (`role_id`) REFERENCES `roles` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ----------------------------
-- Records of role_has_permissions
-- ----------------------------
INSERT INTO `role_has_permissions` VALUES ('1', '1');

-- ----------------------------
-- Table structure for sesiones
-- ----------------------------
DROP TABLE IF EXISTS `sesiones`;
CREATE TABLE `sesiones` (
  `id` bigint(11) unsigned NOT NULL AUTO_INCREMENT,
  `sucursal_id` int(11) NOT NULL,
  `cliente_id` int(11) DEFAULT NULL,
  `terapista_id` bigint(20) unsigned NOT NULL,
  `duracion` time NOT NULL,
  `fecha_asignada` datetime NOT NULL,
  `observaciones` text DEFAULT NULL,
  `asistencia` varchar(10) NOT NULL DEFAULT 'NO',
  `fecha_registro` datetime NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `fecha_modificacion` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `creado_por` int(11) NOT NULL DEFAULT 1,
  `modificado_por` int(11) NOT NULL DEFAULT 1,
  `preferencia_terepista` varchar(2) NOT NULL DEFAULT '0',
  `vale` varchar(2) NOT NULL DEFAULT 'NO',
  `asistencia_cumplida` varchar(10) NOT NULL DEFAULT 'NO',
  `usa_expediente` varchar(2) NOT NULL DEFAULT 'NO',
  `created_at` timestamp NULL DEFAULT NULL ON UPDATE current_timestamp(),
  `updated_at` timestamp NULL DEFAULT NULL ON UPDATE current_timestamp(),
  `aprobado` varchar(10) NOT NULL DEFAULT 'SI',
  `user_id` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `sessiones_sucursal_id` (`sucursal_id`),
  KEY `sessiones_cliente_id` (`cliente_id`),
  KEY `sessiones_terapista_id` (`terapista_id`),
  CONSTRAINT `sessiones_cliente_id` FOREIGN KEY (`cliente_id`) REFERENCES `clientes` (`id`),
  CONSTRAINT `sessiones_sucursal_id` FOREIGN KEY (`sucursal_id`) REFERENCES `sucursales` (`id`),
  CONSTRAINT `sessiones_terapista_id` FOREIGN KEY (`terapista_id`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- ----------------------------
-- Records of sesiones
-- ----------------------------

-- ----------------------------
-- Table structure for sesiones_tratamientos
-- ----------------------------
DROP TABLE IF EXISTS `sesiones_tratamientos`;
CREATE TABLE `sesiones_tratamientos` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `tratamiento_id` int(11) NOT NULL,
  `sesion_id` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL ON UPDATE current_timestamp(),
  `updated_at` timestamp NULL DEFAULT NULL ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `sesiones_tratamientos_tratamiento_id` (`tratamiento_id`),
  KEY `sesiones_tratamientos_sesion_id` (`sesion_id`),
  CONSTRAINT `sesiones_tratamientos_sesion_id` FOREIGN KEY (`sesion_id`) REFERENCES `sesiones` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `sesiones_tratamientos_sucursal_id` FOREIGN KEY (`tratamiento_id`) REFERENCES `tratamientos` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- ----------------------------
-- Records of sesiones_tratamientos
-- ----------------------------

-- ----------------------------
-- Table structure for sucursales
-- ----------------------------
DROP TABLE IF EXISTS `sucursales`;
CREATE TABLE `sucursales` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `clave` varchar(45) DEFAULT NULL,
  `nombre` varchar(200) DEFAULT NULL,
  `correo` varchar(100) DEFAULT NULL,
  `direccion` text DEFAULT NULL,
  `telefono` varchar(45) DEFAULT NULL,
  `estatus` varchar(10) NOT NULL DEFAULT 'activo',
  `fecha_registro` datetime NOT NULL DEFAULT current_timestamp(),
  `fecha_modificacion` timestamp NOT NULL DEFAULT current_timestamp(),
  `creado_por` int(11) NOT NULL DEFAULT 1,
  `modificado_por` int(11) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL ON UPDATE current_timestamp(),
  `updated_at` timestamp NULL DEFAULT NULL ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- ----------------------------
-- Records of sucursales
-- ----------------------------
INSERT INTO `sucursales` VALUES ('1', 'A', 'MATRIZ', null, 'Paseo Usumacinta No. 923, Col. Linda Vista. C.P. 86050', '9933158419', 'activo', '2021-12-07 01:02:32', '2021-12-07 01:02:32', '1', '1', null, null);
INSERT INTO `sucursales` VALUES ('3', 'B', 'PLAZA DEPORTIVA', null, 'Plaza La Mega Local 21, Ciudad Deportiva, Villahermosa, Tabasco, México', '9933152145', 'activo', '2021-12-07 01:02:32', '2021-12-07 01:02:32', '1', '1', null, null);

-- ----------------------------
-- Table structure for sucursales_paneles
-- ----------------------------
DROP TABLE IF EXISTS `sucursales_paneles`;
CREATE TABLE `sucursales_paneles` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `sucursal_id` int(11) NOT NULL,
  `panel_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `sucursales_paneles_sucursal_id` (`sucursal_id`),
  KEY `sucursales_paneles_panel_id` (`panel_id`),
  CONSTRAINT `sucursales_paneles_panel_id` FOREIGN KEY (`panel_id`) REFERENCES `paneles` (`id`),
  CONSTRAINT `sucursales_paneles_sucursal_id` FOREIGN KEY (`sucursal_id`) REFERENCES `sucursales` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- ----------------------------
-- Records of sucursales_paneles
-- ----------------------------

-- ----------------------------
-- Table structure for telefonos
-- ----------------------------
DROP TABLE IF EXISTS `telefonos`;
CREATE TABLE `telefonos` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `sucursal_id` int(11) NOT NULL,
  `telefono` decimal(10,0) NOT NULL,
  `telefono_whatsapp` varchar(12) NOT NULL DEFAULT 'telefono',
  `estatus` varchar(10) NOT NULL DEFAULT 'activo',
  PRIMARY KEY (`id`),
  KEY `telefonos_sucursal_id` (`sucursal_id`),
  CONSTRAINT `telefonos_sucursal_id` FOREIGN KEY (`sucursal_id`) REFERENCES `sucursales` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- ----------------------------
-- Records of telefonos
-- ----------------------------

-- ----------------------------
-- Table structure for timbradores
-- ----------------------------
DROP TABLE IF EXISTS `timbradores`;
CREATE TABLE `timbradores` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `razon_social` varchar(500) NOT NULL,
  `rfc` varchar(45) NOT NULL,
  `estatus` varchar(10) NOT NULL DEFAULT 'activo',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- ----------------------------
-- Records of timbradores
-- ----------------------------

-- ----------------------------
-- Table structure for tipos_bajas
-- ----------------------------
DROP TABLE IF EXISTS `tipos_bajas`;
CREATE TABLE `tipos_bajas` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `descripcion` varchar(100) NOT NULL,
  `estatus` varchar(10) NOT NULL DEFAULT 'activo',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- ----------------------------
-- Records of tipos_bajas
-- ----------------------------

-- ----------------------------
-- Table structure for tipos_equipos
-- ----------------------------
DROP TABLE IF EXISTS `tipos_equipos`;
CREATE TABLE `tipos_equipos` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tipo_equipo` varchar(255) NOT NULL,
  `estatus` varchar(10) NOT NULL DEFAULT 'activo',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- ----------------------------
-- Records of tipos_equipos
-- ----------------------------

-- ----------------------------
-- Table structure for tipos_pagos
-- ----------------------------
DROP TABLE IF EXISTS `tipos_pagos`;
CREATE TABLE `tipos_pagos` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `descripcion` varchar(500) NOT NULL,
  `estatus` varchar(10) NOT NULL DEFAULT 'activo',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- ----------------------------
-- Records of tipos_pagos
-- ----------------------------

-- ----------------------------
-- Table structure for tipos_tratamientos
-- ----------------------------
DROP TABLE IF EXISTS `tipos_tratamientos`;
CREATE TABLE `tipos_tratamientos` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `desc_tipo_tratamiento` varchar(255) DEFAULT NULL,
  `estatus` varchar(255) DEFAULT 'activo',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- ----------------------------
-- Records of tipos_tratamientos
-- ----------------------------
INSERT INTO `tipos_tratamientos` VALUES ('1', 'Circuito de aguas', 'activo');
INSERT INTO `tipos_tratamientos` VALUES ('2', 'Aguas termales y minerales', 'activo');
INSERT INTO `tipos_tratamientos` VALUES ('3', 'Masajes', 'activo');
INSERT INTO `tipos_tratamientos` VALUES ('4', 'Tratamientos médicos', 'activo');
INSERT INTO `tipos_tratamientos` VALUES ('5', 'Tratamientos de belleza', 'activo');
INSERT INTO `tipos_tratamientos` VALUES ('6', 'Pendiente', 'activo');

-- ----------------------------
-- Table structure for traspasos_mercancias
-- ----------------------------
DROP TABLE IF EXISTS `traspasos_mercancias`;
CREATE TABLE `traspasos_mercancias` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `almacen_origen_id` int(11) NOT NULL,
  `almacen_destino_id` int(11) NOT NULL,
  `producto_id` int(11) NOT NULL,
  `cantidad_emisor` float(9,2) NOT NULL,
  `observaciones_emisor` text DEFAULT NULL,
  `cantidad_receptor` float(9,2) DEFAULT NULL,
  `observaciones_receptor` text DEFAULT NULL,
  `recebido` varchar(10) NOT NULL DEFAULT 'no',
  `estatus` varchar(10) NOT NULL DEFAULT 'activo',
  `fecha_registro` datetime NOT NULL DEFAULT current_timestamp(),
  `fecha_modificacion` timestamp NOT NULL DEFAULT current_timestamp(),
  `creado_por` int(11) NOT NULL DEFAULT 1,
  `modificado_por` int(11) NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`),
  KEY `traspasos_mercancias_almacen_origen_id` (`almacen_origen_id`),
  KEY `traspasos_mercancias_almacen_destino_id` (`almacen_destino_id`),
  KEY `traspasos_mercancias_producto_id` (`producto_id`),
  CONSTRAINT `traspasos_mercancias_almacen_destino_id` FOREIGN KEY (`almacen_destino_id`) REFERENCES `almacenes` (`id`),
  CONSTRAINT `traspasos_mercancias_almacen_origen_id` FOREIGN KEY (`almacen_origen_id`) REFERENCES `almacenes` (`id`),
  CONSTRAINT `traspasos_mercancias_producto_id` FOREIGN KEY (`producto_id`) REFERENCES `productos` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- ----------------------------
-- Records of traspasos_mercancias
-- ----------------------------

-- ----------------------------
-- Table structure for tratamientos
-- ----------------------------
DROP TABLE IF EXISTS `tratamientos`;
CREATE TABLE `tratamientos` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `folio` varchar(45) DEFAULT NULL,
  `tratamiento` text DEFAULT NULL,
  `precio` float(9,2) DEFAULT NULL,
  `tiene_iva` varchar(4) NOT NULL DEFAULT 'si',
  `iva` varchar(2) NOT NULL,
  `tiene_ieps` varchar(4) NOT NULL DEFAULT 'no',
  `ieps` varchar(2) NOT NULL,
  `desc_tratamiento` text DEFAULT NULL,
  `sesiones` decimal(10,0) NOT NULL DEFAULT 4,
  `duracion` time NOT NULL DEFAULT '01:00:00',
  `estatus` varchar(10) NOT NULL DEFAULT 'activo',
  `fecha_registro` datetime NOT NULL DEFAULT current_timestamp(),
  `fecha_modificacion` timestamp NOT NULL DEFAULT current_timestamp(),
  `creado_por` int(11) NOT NULL DEFAULT 1,
  `modificado_por` int(11) NOT NULL DEFAULT 1,
  `tipo_tratamiento_id` int(11) NOT NULL DEFAULT 6,
  `secuencia` varchar(2) NOT NULL DEFAULT 'NO',
  `dias` decimal(3,0) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL ON UPDATE current_timestamp(),
  `updated_at` timestamp NULL DEFAULT NULL ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `tratamientos_tipo_tratamiento_id_fk` (`tipo_tratamiento_id`),
  CONSTRAINT `tratamientos_tipo_tratamiento_id_fk` FOREIGN KEY (`tipo_tratamiento_id`) REFERENCES `tipos_tratamientos` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- ----------------------------
-- Records of tratamientos
-- ----------------------------

-- ----------------------------
-- Table structure for users
-- ----------------------------
DROP TABLE IF EXISTS `users`;
CREATE TABLE `users` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `email` varchar(255) NOT NULL,
  `email_verified_at` timestamp NULL DEFAULT NULL,
  `password` varchar(255) NOT NULL,
  `estatus` varchar(10) NOT NULL DEFAULT 'activo',
  `remember_token` varchar(100) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `autorizado` varchar(2) DEFAULT 'si',
  `cliente_id` int(11) DEFAULT NULL,
  `nota` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `users_email_unique` (`email`)
) ENGINE=InnoDB AUTO_INCREMENT=52 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ----------------------------
-- Records of users
-- ----------------------------
INSERT INTO `users` VALUES ('1', 'Deyvi Jesus Gomez Moha', 'deyvijesusgomezmoha@gmail.com', null, '$2y$10$nZ/DfsyJoiW/4J2iCB0Hou6w8jCg7dzC53VNKluEs64a1NYRS47TO', 'activo', null, '2023-08-25 06:41:54', '2023-11-15 04:46:04', 'si', null, null);
INSERT INTO `users` VALUES ('2', 'Administrador', 'admin@gmail.com', null, '$2y$10$m9EnsA8LXfYHZfVsMZ0NPOwhANv3Y.z72JbWp1h.hhZevZFXjif4i', 'activo', null, null, null, 'si', null, null);
INSERT INTO `users` VALUES ('10', 'SRA. BEGO', 'BEGOÑA@gmail.com', null, '$2y$10$m9EnsA8LXfYHZfVsMZ0NPOwhANv3Y.z72JbWp1h.hhZevZFXjif4i', 'activo', null, null, null, 'si', null, null);
INSERT INTO `users` VALUES ('13', 'OFELIA', 'OFELIA@gmail.com', null, '$2y$10$m9EnsA8LXfYHZfVsMZ0NPOwhANv3Y.z72JbWp1h.hhZevZFXjif4i', 'activo', null, null, null, 'si', null, null);
INSERT INTO `users` VALUES ('14', 'LUCY', 'LUCY@gmail.com', null, '$2y$10$m9EnsA8LXfYHZfVsMZ0NPOwhANv3Y.z72JbWp1h.hhZevZFXjif4i', 'activo', null, null, null, 'si', null, null);
INSERT INTO `users` VALUES ('15', 'MARY', 'MARY@gmail.com', null, '$2y$10$m9EnsA8LXfYHZfVsMZ0NPOwhANv3Y.z72JbWp1h.hhZevZFXjif4i', 'activo', null, null, null, 'si', null, null);
INSERT INTO `users` VALUES ('16', 'MARIANA', 'MARIANA@gmail .com', null, '$2y$10$m9EnsA8LXfYHZfVsMZ0NPOwhANv3Y.z72JbWp1h.hhZevZFXjif4i', 'activo', null, null, null, 'si', null, null);
INSERT INTO `users` VALUES ('17', 'JHOANY', 'JHOANY@gmail.com', null, '$2y$10$m9EnsA8LXfYHZfVsMZ0NPOwhANv3Y.z72JbWp1h.hhZevZFXjif4i', 'activo', null, null, null, 'si', null, null);
INSERT INTO `users` VALUES ('18', 'mirena', 'mirena@gmail .com', null, '$2y$10$m9EnsA8LXfYHZfVsMZ0NPOwhANv3Y.z72JbWp1h.hhZevZFXjif4i', 'activo', null, null, null, 'si', null, null);
INSERT INTO `users` VALUES ('20', 'ROSY', 'ROSY@gmail.com', null, '$2y$10$m9EnsA8LXfYHZfVsMZ0NPOwhANv3Y.z72JbWp1h.hhZevZFXjif4i', 'activo', null, null, null, 'si', null, null);
INSERT INTO `users` VALUES ('21', 'MONICA', 'MONICA@gmail.com', null, '$2y$10$m9EnsA8LXfYHZfVsMZ0NPOwhANv3Y.z72JbWp1h.hhZevZFXjif4i', 'activo', null, null, null, 'si', null, null);
INSERT INTO `users` VALUES ('23', 'INGENIERO', 'ricardo@gmail.com', null, '$2y$10$m9EnsA8LXfYHZfVsMZ0NPOwhANv3Y.z72JbWp1h.hhZevZFXjif4i', 'activo', null, null, null, 'si', null, null);
INSERT INTO `users` VALUES ('24', 'mary solis', 'admin_mary@gmail.com', null, '$2y$10$m9EnsA8LXfYHZfVsMZ0NPOwhANv3Y.z72JbWp1h.hhZevZFXjif4i', 'activo', null, null, null, 'si', null, null);
INSERT INTO `users` VALUES ('25', 'LORENA', 'LORENA@gmail.com', null, '$2y$10$m9EnsA8LXfYHZfVsMZ0NPOwhANv3Y.z72JbWp1h.hhZevZFXjif4i', 'activo', null, null, null, 'si', null, null);
INSERT INTO `users` VALUES ('28', 'SUSY', 'SUSY@gmail.com', null, '$2y$10$m9EnsA8LXfYHZfVsMZ0NPOwhANv3Y.z72JbWp1h.hhZevZFXjif4i', 'activo', null, null, null, 'si', null, null);
INSERT INTO `users` VALUES ('34', 'FERNANDA', 'FERNANDA@gmail.com', null, '$2y$10$m9EnsA8LXfYHZfVsMZ0NPOwhANv3Y.z72JbWp1h.hhZevZFXjif4i', 'activo', null, null, null, 'si', null, null);
INSERT INTO `users` VALUES ('35', 'CRISTINA', 'CRISTINA@gmail .com', null, '$2y$10$m9EnsA8LXfYHZfVsMZ0NPOwhANv3Y.z72JbWp1h.hhZevZFXjif4i', 'activo', null, null, null, 'si', null, null);
INSERT INTO `users` VALUES ('36', 'no asignada', 'no asignada@gmail.com', null, '$2y$10$m9EnsA8LXfYHZfVsMZ0NPOwhANv3Y.z72JbWp1h.hhZevZFXjif4i', 'activo', null, null, null, 'si', null, null);
INSERT INTO `users` VALUES ('37', 'LORENA', 'admin_lorena@gmail.com', null, '$2y$10$m9EnsA8LXfYHZfVsMZ0NPOwhANv3Y.z72JbWp1h.hhZevZFXjif4i', 'activo', null, null, null, 'si', null, null);
INSERT INTO `users` VALUES ('38', 'mega', 'mega@gmail.com', null, '$2y$10$m9EnsA8LXfYHZfVsMZ0NPOwhANv3Y.z72JbWp1h.hhZevZFXjif4i', 'activo', null, null, null, 'si', null, null);
INSERT INTO `users` VALUES ('39', 'ALONDRA', 'ALONDRA@gmail.com', null, '$2y$10$m9EnsA8LXfYHZfVsMZ0NPOwhANv3Y.z72JbWp1h.hhZevZFXjif4i', 'activo', null, null, null, 'si', null, null);
INSERT INTO `users` VALUES ('40', 'KARLA', 'KARLA@gmail.com', null, '$2y$10$m9EnsA8LXfYHZfVsMZ0NPOwhANv3Y.z72JbWp1h.hhZevZFXjif4i', 'activo', null, null, null, 'si', null, null);
INSERT INTO `users` VALUES ('41', 'MARIA', 'MARIA@gmail.com', null, '$2y$10$m9EnsA8LXfYHZfVsMZ0NPOwhANv3Y.z72JbWp1h.hhZevZFXjif4i', 'activo', null, null, null, 'si', null, null);
INSERT INTO `users` VALUES ('42', 'JANETH', 'JANETH@gmail.com', null, '$2y$10$m9EnsA8LXfYHZfVsMZ0NPOwhANv3Y.z72JbWp1h.hhZevZFXjif4i', 'activo', null, null, null, 'si', null, null);
INSERT INTO `users` VALUES ('43', 'ANI', 'ANI@gmail.com', null, '$2y$10$m9EnsA8LXfYHZfVsMZ0NPOwhANv3Y.z72JbWp1h.hhZevZFXjif4i', 'activo', null, null, null, 'si', null, null);
INSERT INTO `users` VALUES ('44', 'TERESITA', 'TERESITA@gmail.com', null, '$2y$10$m9EnsA8LXfYHZfVsMZ0NPOwhANv3Y.z72JbWp1h.hhZevZFXjif4i', 'activo', null, null, null, 'si', null, null);

-- ----------------------------
-- Table structure for users_sucursales
-- ----------------------------
DROP TABLE IF EXISTS `users_sucursales`;
CREATE TABLE `users_sucursales` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL,
  `sucursal_id` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL ON UPDATE current_timestamp(),
  `updated_at` timestamp NULL DEFAULT NULL ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `users_sucursales_user_id` (`user_id`),
  KEY `users_sucursales_sucursal_id` (`sucursal_id`),
  CONSTRAINT `users_sucursales_sucursal_id` FOREIGN KEY (`sucursal_id`) REFERENCES `sucursales` (`id`),
  CONSTRAINT `users_sucursales_user_id` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=51 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- ----------------------------
-- Records of users_sucursales
-- ----------------------------
INSERT INTO `users_sucursales` VALUES ('16', '10', '1', null, null);
INSERT INTO `users_sucursales` VALUES ('17', '10', '3', null, null);
INSERT INTO `users_sucursales` VALUES ('18', '13', '1', null, null);
INSERT INTO `users_sucursales` VALUES ('19', '13', '3', null, null);
INSERT INTO `users_sucursales` VALUES ('20', '14', '1', null, null);
INSERT INTO `users_sucursales` VALUES ('21', '15', '1', null, null);
INSERT INTO `users_sucursales` VALUES ('22', '17', '1', null, null);
INSERT INTO `users_sucursales` VALUES ('23', '20', '3', null, null);
INSERT INTO `users_sucursales` VALUES ('24', '21', '1', null, null);
INSERT INTO `users_sucursales` VALUES ('25', '21', '3', null, null);
INSERT INTO `users_sucursales` VALUES ('26', '23', '1', null, null);
INSERT INTO `users_sucursales` VALUES ('27', '23', '3', null, null);
INSERT INTO `users_sucursales` VALUES ('28', '24', '1', null, null);
INSERT INTO `users_sucursales` VALUES ('29', '24', '3', null, null);
INSERT INTO `users_sucursales` VALUES ('30', '25', '1', null, null);
INSERT INTO `users_sucursales` VALUES ('31', '25', '3', null, null);
INSERT INTO `users_sucursales` VALUES ('32', '28', '1', null, null);
INSERT INTO `users_sucursales` VALUES ('33', '28', '3', null, null);
INSERT INTO `users_sucursales` VALUES ('34', '34', '1', null, null);
INSERT INTO `users_sucursales` VALUES ('35', '34', '3', null, null);
INSERT INTO `users_sucursales` VALUES ('36', '36', '1', null, null);
INSERT INTO `users_sucursales` VALUES ('37', '36', '3', null, null);
INSERT INTO `users_sucursales` VALUES ('38', '38', '3', null, null);
INSERT INTO `users_sucursales` VALUES ('39', '39', '1', null, null);
INSERT INTO `users_sucursales` VALUES ('40', '39', '3', null, null);
INSERT INTO `users_sucursales` VALUES ('41', '40', '1', null, null);
INSERT INTO `users_sucursales` VALUES ('42', '40', '3', null, null);
INSERT INTO `users_sucursales` VALUES ('43', '41', '1', null, null);
INSERT INTO `users_sucursales` VALUES ('44', '41', '3', null, null);
INSERT INTO `users_sucursales` VALUES ('45', '42', '1', null, null);
INSERT INTO `users_sucursales` VALUES ('46', '42', '3', null, null);
INSERT INTO `users_sucursales` VALUES ('47', '43', '1', null, null);
INSERT INTO `users_sucursales` VALUES ('48', '43', '3', null, null);
INSERT INTO `users_sucursales` VALUES ('49', '44', '1', null, null);
INSERT INTO `users_sucursales` VALUES ('50', '44', '3', null, null);

-- ----------------------------
-- Table structure for vales
-- ----------------------------
DROP TABLE IF EXISTS `vales`;
CREATE TABLE `vales` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `venta_id` bigint(20) unsigned NOT NULL,
  `total` float(9,2) DEFAULT NULL,
  `precio_unitario` float(9,2) DEFAULT NULL,
  `imagen_qr` text NOT NULL,
  `tiene_iva` varchar(4) NOT NULL DEFAULT 'si',
  `iva` float(9,2) DEFAULT NULL,
  `tiene_ieps` varchar(4) NOT NULL DEFAULT 'no',
  `ieps` float(9,2) DEFAULT NULL,
  `token` text NOT NULL,
  `vigencia` datetime NOT NULL,
  `estatus` varchar(10) NOT NULL DEFAULT 'activo',
  `cancelado` varchar(10) NOT NULL DEFAULT 'no',
  `fecha_registro` datetime NOT NULL DEFAULT current_timestamp(),
  `fecha_modificacion` timestamp NOT NULL DEFAULT current_timestamp(),
  `creado_por` int(11) NOT NULL DEFAULT 1,
  `modificado_por` int(11) NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`),
  KEY `vales_venta_id` (`venta_id`),
  CONSTRAINT `vales_venta_id` FOREIGN KEY (`venta_id`) REFERENCES `ventas` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- ----------------------------
-- Records of vales
-- ----------------------------

-- ----------------------------
-- Table structure for vales_sessiones
-- ----------------------------
DROP TABLE IF EXISTS `vales_sessiones`;
CREATE TABLE `vales_sessiones` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `vale_id` bigint(20) unsigned NOT NULL,
  `session_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `vales_sessiones_vale_id` (`vale_id`),
  KEY `vales_sessiones_session_id` (`session_id`),
  CONSTRAINT `vales_sessiones_session_id` FOREIGN KEY (`session_id`) REFERENCES `sesiones` (`id`),
  CONSTRAINT `vales_sessiones_vale_id` FOREIGN KEY (`vale_id`) REFERENCES `vales` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- ----------------------------
-- Records of vales_sessiones
-- ----------------------------

-- ----------------------------
-- Table structure for ventas
-- ----------------------------
DROP TABLE IF EXISTS `ventas`;
CREATE TABLE `ventas` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `sucursal_id` int(11) NOT NULL,
  `cliente_id` int(11) NOT NULL,
  `timbrador_id` int(11) NOT NULL,
  `total` float(9,2) DEFAULT NULL,
  `subtotal` float(9,2) DEFAULT NULL,
  `iva` float(9,2) DEFAULT NULL,
  `eps` float(9,2) DEFAULT NULL,
  `estatus` varchar(10) NOT NULL DEFAULT 'activo',
  `cancelado` varchar(10) NOT NULL DEFAULT 'no',
  `fecha_registro` datetime NOT NULL DEFAULT current_timestamp(),
  `fecha_modificacion` timestamp NOT NULL DEFAULT current_timestamp(),
  `creado_por` int(11) NOT NULL DEFAULT 1,
  `modificado_por` int(11) NOT NULL DEFAULT 1,
  `es_credito` varchar(4) NOT NULL DEFAULT 'no',
  PRIMARY KEY (`id`),
  KEY `ventas_sucursal_id` (`sucursal_id`),
  KEY `ventas_cliente_id` (`cliente_id`),
  KEY `ventas_timbrador_id` (`timbrador_id`),
  CONSTRAINT `ventas_cliente_id` FOREIGN KEY (`cliente_id`) REFERENCES `clientes` (`id`),
  CONSTRAINT `ventas_sucursal_id` FOREIGN KEY (`sucursal_id`) REFERENCES `sucursales` (`id`),
  CONSTRAINT `ventas_timbrador_id` FOREIGN KEY (`timbrador_id`) REFERENCES `timbradores` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- ----------------------------
-- Records of ventas
-- ----------------------------

-- ----------------------------
-- Table structure for ventas_cortes
-- ----------------------------
DROP TABLE IF EXISTS `ventas_cortes`;
CREATE TABLE `ventas_cortes` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `venta_id` bigint(20) unsigned NOT NULL,
  `corte_caja_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ventas_cortes_venta_id` (`venta_id`),
  KEY `ventas_cortes_caja_corte_id` (`corte_caja_id`),
  CONSTRAINT `ventas_cortes_caja_corte_id` FOREIGN KEY (`corte_caja_id`) REFERENCES `cortes_cajas` (`id`),
  CONSTRAINT `ventas_cortes_venta_id` FOREIGN KEY (`venta_id`) REFERENCES `ventas` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- ----------------------------
-- Records of ventas_cortes
-- ----------------------------

-- ----------------------------
-- Table structure for ventas_detalles
-- ----------------------------
DROP TABLE IF EXISTS `ventas_detalles`;
CREATE TABLE `ventas_detalles` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `venta_id` bigint(20) unsigned NOT NULL,
  `producto_id` int(11) NOT NULL,
  `total` float(9,2) DEFAULT NULL,
  `subtotal` float(9,2) DEFAULT NULL,
  `precio_unitario` float(9,2) DEFAULT NULL,
  `cantidad` float(9,2) DEFAULT NULL,
  `iva` float(9,2) DEFAULT NULL,
  `eps` float(9,2) DEFAULT NULL,
  `estatus` varchar(10) NOT NULL DEFAULT 'activo',
  `cancelado` varchar(10) NOT NULL DEFAULT 'no',
  `fecha_registro` datetime NOT NULL DEFAULT current_timestamp(),
  `fecha_modificacion` timestamp NOT NULL DEFAULT current_timestamp(),
  `creado_por` int(11) NOT NULL DEFAULT 1,
  `modificado_por` int(11) NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`),
  KEY `ventas_detalles_venta_id` (`venta_id`),
  KEY `ventas_detalles_producto_id` (`producto_id`),
  CONSTRAINT `ventas_detalles_producto_id` FOREIGN KEY (`producto_id`) REFERENCES `productos` (`id`),
  CONSTRAINT `ventas_detalles_venta_id` FOREIGN KEY (`venta_id`) REFERENCES `ventas` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- ----------------------------
-- Records of ventas_detalles
-- ----------------------------

-- ----------------------------
-- Table structure for ventas_tratamientos
-- ----------------------------
DROP TABLE IF EXISTS `ventas_tratamientos`;
CREATE TABLE `ventas_tratamientos` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `venta_id` bigint(20) unsigned NOT NULL,
  `tratamiento_id` int(11) NOT NULL,
  `total` float(9,2) DEFAULT NULL,
  `subtotal` float(9,2) DEFAULT NULL,
  `precio_unitario` float(9,2) DEFAULT NULL,
  `cantidad` float(9,2) DEFAULT NULL,
  `iva` float(9,2) DEFAULT NULL,
  `eps` float(9,2) DEFAULT NULL,
  `estatus` varchar(10) NOT NULL DEFAULT 'activo',
  `cancelado` varchar(10) NOT NULL DEFAULT 'no',
  `fecha_registro` datetime NOT NULL DEFAULT current_timestamp(),
  `fecha_modificacion` timestamp NOT NULL DEFAULT current_timestamp(),
  `creado_por` int(11) NOT NULL DEFAULT 1,
  `modificado_por` int(11) NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`),
  KEY `ventas_tratamientos_venta_id` (`venta_id`),
  KEY `ventas_tratamientos_tratamiento_id` (`tratamiento_id`),
  CONSTRAINT `ventas_tratamientos_tratamiento_id` FOREIGN KEY (`tratamiento_id`) REFERENCES `tratamientos` (`id`),
  CONSTRAINT `ventas_tratamientos_venta_id` FOREIGN KEY (`venta_id`) REFERENCES `ventas` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- ----------------------------
-- Records of ventas_tratamientos
-- ----------------------------
