@extends('mails.layout')

@section('content')
    <h2>Correo de Prueba</h2>
    <p>Este es un correo de prueba del sistema de correos de <strong>EGURROLA</strong>.</p>
    
    <div class="info-box">
        <p><strong>📧 Información de la Configuración</strong></p>
        <table class="data-table">
            <tr>
                <td>Configuración:</td>
                <td><strong>{{ $configuracion->nombre ?? 'N/A' }}</strong></td>
            </tr>
            <tr>
                <td>Correo de prueba:</td>
                <td>{{ $configuracion->correo_prueba ?? 'N/A' }}</td>
            </tr>
            <tr>
                <td>Modo prueba:</td>
                <td><strong>{{ ($configuracion->modo_prueba ?? false) ? 'Activo' : 'Inactivo' }}</strong></td>
            </tr>
            <tr>
                <td>Estado:</td>
                <td><strong>{{ ($configuracion->es_activa ?? false) ? 'Activa' : 'Inactiva' }}</strong></td>
            </tr>
            <tr>
                <td>Fecha de prueba:</td>
                <td><strong>{{ now()->format('d/m/Y H:i:s') }}</strong></td>
            </tr>
        </table>
    </div>

    <p>Si recibió este correo, significa que la configuración de correo está funcionando correctamente.</p>
    
    <p>Este correo fue enviado desde el sistema de configuración de correos de EGURROLA para verificar que todo esté configurado adecuadamente.</p>

    <div class="info-box">
        <p><strong>✅ Todos los templates de correo disponibles:</strong></p>
        <ul>
            <li>Venta confirmada al cliente</li>
            <li>Nueva venta al cliente</li>
            <li>Nueva venta al administrador</li>
            <li>Nuevo cliente registrado</li>
            <li>Nueva solicitud de cita</li>
            <li>Restablecimiento de contraseña</li>
            <li>Cuenta activada</li>
            <li>Cita autorizada</li>
            <li>Registro completado</li>
        </ul>
    </div>

    <p>Gracias por usar el sistema de correos de EGURROLA.</p>
    <p>Atentamente,<br><strong>Clínica EGURROLA</strong></p>
@endsection

@php
    $title = 'Correo de Prueba - EGURROLA';
    $headerTitle = 'Correo de Prueba';
@endphp

