@extends('mails.layout')

@section('content')
    <h2>¡Venta Confirmada!</h2>
    <p>Estimado/a <strong>{{ $venta->cliente->razonSocial }}</strong>,</p>
    <p>Nos complace informarle que su venta ha sido confirmada exitosamente. A continuación encontrará los detalles de su compra:</p>
    
    <table class="data-table">
        <tr>
            <td>Cliente:</td>
            <td>{{ $venta->cliente->razonSocial }}</td>
        </tr>
        <tr>
            <td>Correo electrónico:</td>
            <td>{{ $venta->cliente->email }}</td>
        </tr>
        <tr>
            <td>Total:</td>
            <td><strong>${{ number_format($venta->total, 2) }}</strong></td>
        </tr>
        <tr>
            <td>Fecha:</td>
            <td>{{ \Carbon\Carbon::parse($venta->fecha)->format('d/m/Y') }}</td>
        </tr>
    </table>

    <div class="info-box">
        <h3 style="margin-top: 0; color: #e8c39e">Información Importante:</h3>
        <ul>
            <li>La validación de su pago puede tardar hasta 2 días hábiles.</li>
            <li>Recibirá una notificación cuando su pago sea confirmado.</li>
            <li>Su pedido será procesado una vez confirmado el pago.</li>
        </ul>
    </div>

    <p>Gracias por confiar en nosotros. Estamos trabajando para brindarle el mejor servicio.</p>
    <p>Atentamente,<br><strong>Clínica EGURROLA</strong></p>
@endsection

@php
    $title = 'Venta Confirmada - EGURROLA';
    $headerTitle = 'Venta Confirmada';
@endphp