@extends('mails.layout')

@section('content')
    <h2>Nueva Venta Registrada</h2>
    <p>Estimado/a <strong>{{ $venta->cliente->razonSocial }}</strong>,</p>
    <p>Hemos recibido su solicitud de compra. Su venta ha sido registrada exitosamente el <strong>{{ \Carbon\Carbon::parse($venta->created_at)->format('d/m/Y H:i') }}</strong>.</p>
    
    <table class="data-table">
        <tr>
            <td>Cliente:</td>
            <td>{{ $venta->cliente->razonSocial }}</td>
        </tr>
        <tr>
            <td>Correo electrónico:</td>
            <td>{{ $venta->cliente->email }}</td>
        </tr>
        <tr>
            <td>Total:</td>
            <td><strong>${{ number_format($venta->total, 2) }}</strong></td>
        </tr>
        <tr>
            <td>Fecha:</td>
            <td>{{ \Carbon\Carbon::parse($venta->fecha)->format('d/m/Y') }}</td>
        </tr>
        <tr>
            <td>Estado:</td>
            <td><strong>{{ ucfirst($venta->status) }}</strong></td>
        </tr>
    </table>

    <div class="info-box">
        <p><strong>⚠️ Pendiente de validación</strong></p>
        <p>Su venta aún se encuentra pendiente de validación mediante el comprobante de pago. Una vez que nuestro equipo revise y valide su comprobante, recibirá una notificación de confirmación.</p>
    </div>

    <div class="info-box">
        <h3 style="margin-top: 0; color: #e8c39e">Próximos pasos:</h3>
        <ul>
            <li>La validación de su pago puede tardar hasta 2 días hábiles.</li>
            <li>Recibirá una notificación cuando su pago sea confirmado.</li>
            <li>Su pedido será procesado una vez confirmado el pago.</li>
        </ul>
    </div>

    <p>Gracias por su preferencia. Estamos a su disposición para cualquier consulta.</p>
    <p>Atentamente,<br><strong>Clínica EGURROLA</strong></p>
@endsection

@php
    $title = 'Nueva Venta - EGURROLA';
    $headerTitle = 'Nueva Venta';
@endphp