@extends('mails.layout')

@section('content')
    <h2>Nueva Venta Registrada</h2>
    <p>Se ha registrado una nueva venta en el sistema el <strong>{{ \Carbon\Carbon::parse($venta->created_at)->format('d/m/Y H:i') }}</strong>.</p>
    
    <table class="data-table">
        <tr>
            <td>Cliente:</td>
            <td><strong>{{ $venta->cliente->razonSocial }}</strong></td>
        </tr>
        <tr>
            <td>Total:</td>
            <td><strong>${{ number_format($venta->total, 2) }}</strong></td>
        </tr>
        <tr>
            <td>Fecha:</td>
            <td>{{ \Carbon\Carbon::parse($venta->fecha)->format('d/m/Y') }}</td>
        </tr>
        <tr>
            <td>Estado:</td>
            <td><strong>{{ ucfirst($venta->status) }}</strong></td>
        </tr>
    </table>

    <div class="info-box">
        <p><strong>⚠️ Acción Requerida</strong></p>
        <p>Esta venta requiere validación mediante el comprobante de pago. Por favor, revise y valide el comprobante en el sistema.</p>
    </div>

    <p>Por favor, acceda al sistema para revisar los detalles completos de la venta y proceder con la validación.</p>
@endsection

@php
    $title = 'Nueva Venta - Notificación Administrativa';
    $headerTitle = 'Nueva Venta';
@endphp