@extends('mails.layout')

@section('content')
    <h2>Nuevo Cliente Registrado</h2>
    <p>Se ha registrado un nuevo cliente en el sistema el <strong>{{ \Carbon\Carbon::parse($user->created_at)->format('d/m/Y H:i') }}</strong>.</p>
    
    <p>A continuación encontrará los datos del nuevo usuario:</p>
    
    <table class="data-table">
        <tr>
            <td>Nombre:</td>
            <td><strong>{{ $user->name }}</strong></td>
        </tr>
        <tr>
            <td>Correo electrónico:</td>
            <td>{{ $user->email }}</td>
        </tr>
        <tr>
            <td>Fecha de registro:</td>
            <td>{{ \Carbon\Carbon::parse($user->created_at)->format('d/m/Y H:i') }}</td>
        </tr>
    </table>

    <div class="info-box">
        <p><strong>📋 Próximos pasos:</strong></p>
        <ul>
            <li>Revise los datos del cliente en el sistema.</li>
            <li>Valide la información proporcionada.</li>
            <li>Active la cuenta del cliente cuando esté listo.</li>
        </ul>
    </div>

    <p>Por favor, acceda al sistema para revisar los detalles completos del nuevo cliente.</p>
@endsection

@php
    $title = 'Nuevo Cliente Registrado - Notificación Administrativa';
    $headerTitle = 'Nuevo Cliente';
@endphp