@extends('mails.layout')

@section('content')
    <h2>¡Cita Autorizada!</h2>
    <p>Estimado/a <strong>{{ $sesion->cliente->razonSocial }}</strong>,</p>
    <p>Nos complace informarle que su solicitud de cita ha sido autorizada exitosamente.</p>
    
    <table class="data-table">
        <tr>
            <td>Folio:</td>
            <td><strong>#{{ $sesion->id }}</strong></td>
        </tr>
        <tr>
            <td>Fecha y hora:</td>
            <td><strong>{{ \Carbon\Carbon::parse($sesion->fecha_asignada)->format('d/m/Y H:i') }}</strong></td>
        </tr>
        <tr>
            <td>Sucursal:</td>
            <td><strong>{{ $sesion->sucursal->nombre }}</strong></td>
        </tr>
        @if(isset($sesion->terapista) && $sesion->terapista)
        <tr>
            <td>Terapeuta:</td>
            <td><strong>{{ $sesion->terapista->name }}</strong></td>
        </tr>
        @endif
    </table>

    <div class="info-box">
        <p><strong>📅 Recordatorio Importante</strong></p>
        <ul>
            <li>Por favor, llegue 10 minutos antes de su cita programada.</li>
            <li>Si necesita cancelar o reprogramar, hágalo con al menos 24 horas de anticipación.</li>
            <li>En caso de no poder asistir, notifique con la mayor brevedad posible.</li>
        </ul>
    </div>

    <p>Esperamos atenderle y brindarle una excelente experiencia.</p>
    <p>Si tiene alguna pregunta o necesita realizar algún cambio, no dude en contactarnos.</p>
    <p>Atentamente,<br><strong>Clínica EGURROLA</strong></p>
@endsection

@php
    $title = 'Cita Autorizada - EGURROLA';
    $headerTitle = 'Cita Autorizada';
@endphp