import ApiService from "@/services/ApiService";
import ApiServiceFile from "@/services/ApiServiceFile";

const baseUrl = "ventas";

export const getAll = async () => {
  const response = await ApiService.get(`${baseUrl}/all`);
  return response.data;
};

export const getMisCompras = async (params) => {
  const response = await ApiService.post(`${baseUrl}/mis-compras`,params);
  return response.data;
};

export const getPage = async (page,perPage,params) => {
  const response = await ApiService.post(`${baseUrl}/page?page=${page}&perPage=${perPage}`,params);
  return response.data;
};

export const createVenta = async (params) => {
  const response = await ApiService.post(`${baseUrl}/create`, params);
  return response.data;
};

export const getVentaId = async (venta_id) => {
  const response = await ApiService.get(`${baseUrl}/${venta_id}`);
  return response.data;
};

export const canledadoVenta = async (params, venta_id) => {
  const response = await ApiService.put(
    `${baseUrl}/${venta_id}/canledado`,
    params
  );
  return response.data;
};

export const deleteVenta = async (venta_id) => {
  const response = await ApiService.delete(`${baseUrl}/${venta_id}`);
  return response.data;
};

export const seedValeTicket = async (params, agendar_clase_id) => {
  const response = await ApiServiceFile.post(`${baseUrl}/seed-ticket/${agendar_clase_id}`, params);
  return response.data;
};

export const paginacionTiendaVerificar = async (page,perPage,params) => {
  const response = await ApiService.post(`${baseUrl}/tienda/verificar?page=${page}&perPage=${perPage}`, params);
  return response.data;
};

export const autorizarVenta = async (params, venta_id) => {
  const response = await ApiService.put(`${baseUrl}/${venta_id}/autorizar`, params);
  return response.data;
};

export const rellenarEnvioActualizar = async (params, id) => {
  const response = await ApiService.put(`envios/${id}/edit`, params);
  return response.data;
};

export const rellenarEnvioCrear = async (params) => {
  const response = await ApiService.post(`envios/create`, params);
  return response.data;
};