import ApiService from "@/services/ApiService";

const baseUrl = "tratamientos";

export const getAll = async ($params) => {
  const response = await ApiService.post(`${baseUrl}/all`,$params);
  return response.data;
};

export const createTratamiento = async (params) => {
  const response = await ApiService.post(`${baseUrl}/create`, params);
  return response.data;
};

export const getTratamientoId = async (tratamiento_id) => {
  const response = await ApiService.get(`${baseUrl}/${tratamiento_id}`);
  return response.data;
};

export const updateTratamiento = async (params, tratamiento_id) => {
  const response = await ApiService.put(
    `${baseUrl}/${tratamiento_id}/edit`,
    params
  );
  return response.data;
};

export const deleteTratamiento = async (tratamiento_id) => {
  const response = await ApiService.delete(`${baseUrl}/${tratamiento_id}`);
  return response.data;
};

