import ApiService from "@/services/ApiService";

const baseUrl = "tipos-tratamientos";

export const getAll = async ($params) => {
  const response = await ApiService.post(`${baseUrl}/all`,$params);
  return response.data;
};

export const createTipoTratamiento = async (params) => {
  const response = await ApiService.post(`${baseUrl}/create`, params);
  return response.data;
};

export const getTipoTratamientoId = async (tipo_tratamiento_id) => {
  const response = await ApiService.get(`${baseUrl}/${tipo_tratamiento_id}`);
  return response.data;
};

export const updateTipoTratamiento = async (params, tipo_tratamiento_id) => {
  const response = await ApiService.put(
    `${baseUrl}/${tipo_tratamiento_id}/edit`,
    params
  );
  return response.data;
};

export const deleteTipoTratamiento = async (tipo_tratamiento_id) => {
  const response = await ApiService.delete(`${baseUrl}/${tipo_tratamiento_id}`);
  return response.data;
};

