import ApiService from "@/services/ApiService";

const baseUrl = "sucursales";

export const getIndex = async () => {
  const response = await ApiService.get(`${baseUrl}/index`);
  return response.data;
};

export const getAll = async () => {
  const response = await ApiService.get(`${baseUrl}/all`);
  return response.data;
};

export const createSucursal = async (params) => {
  const response = await ApiService.post(`${baseUrl}/create`, params);
  return response.data;
};

export const getSucursalId = async (sucursal_id) => {
  const response = await ApiService.get(`${baseUrl}/${sucursal_id}`);
  return response.data;
};

export const updateSucursal = async (params, sucursal_id) => {
  const response = await ApiService.put(
    `${baseUrl}/${sucursal_id}/edit`,
    params
  );
  return response.data;
};

export const deleteSucursal = async (sucursal_id) => {
  const response = await ApiService.delete(`${baseUrl}/${sucursal_id}`);
  return response.data;
};
