import ApiService from "@/services/ApiService";

const baseUrl = "opciones-pago-transferencia";

export const getPage = async () => {
  const response = await ApiService.get(`${baseUrl}/all`);
  return response.data;
};

export const createOpcionPagoTransferencia = async (params) => {
  const response = await ApiService.post(`${baseUrl}/create`, params);
  return response.data;
};

export const getOpcionPagoTransferenciaId = async (id) => {
  const response = await ApiService.get(`${baseUrl}/${id}`);
  return response.data;
};

export const updateOpcionPagoTransferencia = async (params, id) => {
  const response = await ApiService.put(`${baseUrl}/${id}/edit`, params);
  return response.data;
};

export const deleteOpcionPagoTransferencia = async (id) => {
  const response = await ApiService.delete(`${baseUrl}/${id}`);
  return response.data;
};

export const getOpcionPagoTransferenciaForSelect = async () => {
  const response = await ApiService.get(`${baseUrl}/for-select`);
  return response.data;
};

export const getOpcionPagoTransferenciaPrincipal = async () => {
  const response = await ApiService.get(`${baseUrl}/principal`);
  return response.data;
};
