import ApiService from "@/services/ApiService";

const baseUrl = "marcas";

export const getAll = async ($params) => {
  const response = await ApiService.post(`${baseUrl}/all`,$params);
  return response.data;
};

export const createMarca = async (params) => {
  const response = await ApiService.post(`${baseUrl}/create`, params);
  return response.data;
};

export const getMarcaId = async (marca_id) => {
  const response = await ApiService.get(`${baseUrl}/${marca_id}`);
  return response.data;
};

export const updateMarca = async (params, marca_id) => {
  const response = await ApiService.put(
    `${baseUrl}/${marca_id}/edit`,
    params
  );
  return response.data;
};

export const deleteMarca = async (marca_id) => {
  const response = await ApiService.delete(`${baseUrl}/${marca_id}`);
  return response.data;
};

