import ApiService from "@/services/ApiService";

const baseUrl = "inventarios";

export const getAll = async ($params) => {
  const response = await ApiService.post(`${baseUrl}/all`,$params);
  return response.data;
};

export const getPage = async (page,perPage,params) => {
  const response = await ApiService.post(`${baseUrl}/page?page=${page}&perPage=${perPage}`,params);
  return response.data;
};

export const createInventario = async (params) => {
  const response = await ApiService.post(`${baseUrl}/create`, params);
  return response.data;
};

export const getInventarioId = async (inventario_id) => {
  const response = await ApiService.get(`${baseUrl}/${inventario_id}`);
  return response.data;
};

export const updateInventario = async (params, inventario_id) => {
  const response = await ApiService.put(
    `${baseUrl}/${inventario_id}/edit`,
    params
  );
  return response.data;
};

export const deleteInventario = async (inventario_id) => {
  const response = await ApiService.delete(`${baseUrl}/${inventario_id}`);
  return response.data;
};

