import ApiService from "@/services/ApiService";

const baseUrl = "ingresos-mercancias";

export const getAll = async () => {
  const response = await ApiService.get(`${baseUrl}/all`);
  return response.data;
};

export const getPage = async (page,perPage,params) => {
  const response = await ApiService.post(`${baseUrl}/page?page=${page}&perPage=${perPage}`,params);
  return response.data;
};

export const createIngresoMercancia = async (params) => {
  const response = await ApiService.post(`${baseUrl}/create`, params);
  return response.data;
};

export const getIngresoMercanciaId = async (ingreso_id) => {
  const response = await ApiService.get(`${baseUrl}/${ingreso_id}`);
  return response.data;
};

export const updateIngresoMercancia = async (params, ingreso_id) => {
  const response = await ApiService.put(
    `${baseUrl}/${ingreso_id}/edit`,
    params
  );
  return response.data;
};

export const deleteIngresoMercancia = async (ingreso_id) => {
  const response = await ApiService.delete(`${baseUrl}/${ingreso_id}`);
  return response.data;
};

