import ApiService from "@/services/ApiService";

const baseUrl = "horarios";

export const getAll = async () => {
  const response = await ApiService.get(`${baseUrl}/all`);
  return response.data;
};

export const createHorario = async (params) => {
  const response = await ApiService.post(`${baseUrl}/create`, params);
  return response.data;
};

export const getHorarioId = async (horario_id) => {
  const response = await ApiService.get(`${baseUrl}/${horario_id}`);
  return response.data;
};

export const updateHorario = async (params, horario_id) => {
  const response = await ApiService.put(
    `${baseUrl}/${horario_id}/edit`,
    params
  );
  return response.data;
};

export const deleteHorario = async (horario_id) => {
  const response = await ApiService.delete(`${baseUrl}/${horario_id}`);
  return response.data;
};

export const getDias = async (sucursal_id) => {
  const response = await ApiService.get(
    `${baseUrl}/${sucursal_id}/dias`
  );
  return response.data;
};

export const getDisponibles = async (params) => {
    const response = await ApiService.post(`${baseUrl}/disponibles`, params);
    return response.data;
};
