import ApiService from "@/services/ApiService";

const baseUrl = "direcciones-entrega";

export const getPage = async (clienteId) => {
  const response = await ApiService.get(`${baseUrl}/all/${clienteId}`);
  return response.data;
};

export const createDireccion = async (params) => {
  const response = await ApiService.post(`${baseUrl}/create`, params);
  return response.data;
};

export const getDireccionId = async (id) => {
  const response = await ApiService.get(`${baseUrl}/${id}`);
  return response.data;
};

export const updateDireccion = async (params, id) => {
  const response = await ApiService.put(`${baseUrl}/${id}/edit`, params);
  return response.data;
};

export const deleteDireccion = async (id) => {
  const response = await ApiService.delete(`${baseUrl}/${id}`);
  return response.data;
};

export const getDireccionForSelect = async (clienteId) => {
  const response = await ApiService.get(`${baseUrl}/for-select/${clienteId}`);
  return response.data;
};
