# 🚀 Inicio Rápido con Docker

## Opción 1: Script Automático (Recomendado)

### Linux/Mac:
```bash
./docker/scripts/setup.sh
```

### Windows:
```cmd
docker\scripts\setup.bat
```

## Opción 2: Manual

### 1. Levantar contenedores
```bash
docker-compose up -d
```

### 2. Instalar dependencias PHP
```bash
docker-compose exec app composer install
```

### 3. Instalar dependencias Node
```bash
docker-compose exec node npm install
```

### 4. Configurar .env
```bash
# Si tienes .env.example
docker-compose exec app cp .env.example .env

# Edita .env con estas credenciales:
# DB_HOST=mysql
# DB_PORT=3306
# DB_DATABASE=egurrola
# DB_USERNAME=egurrola_user
# DB_PASSWORD=egurrola_password
```

### 5. Generar clave de aplicación
```bash
docker-compose exec app php artisan key:generate
```

### 6. Configurar permisos
```bash
docker-compose exec app chmod -R 775 storage bootstrap/cache
docker-compose exec app chown -R www-data:www-data storage bootstrap/cache
```

### 7. Compilar assets
```bash
docker-compose exec node npm run dev
```

### 8. Ejecutar migraciones
```bash
docker-compose exec app php artisan migrate
```

## 🌐 Accesos

- **Aplicación**: http://localhost:8080
- **phpMyAdmin**: http://localhost:8081
- **MySQL**: localhost:3307

## 📚 Documentación Completa

Ver [docker/README.md](README.md) para documentación detallada.


