# 🔧 Configurar Puerto 8080 en Laravel/Vue

## ⚠️ Problema

Si al hacer click en la aplicación sigue redirigiendo al puerto **8000** en lugar de **8080**, necesitas actualizar las variables de entorno y recompilar los assets.

## 📝 Pasos para Solucionar

### 1. Actualizar archivo `.env`

Abre o crea el archivo `.env` en la raíz del proyecto y asegúrate de tener estas variables:

```env
APP_URL=http://localhost:8080

# Variables para Laravel Mix (Vue.js)
MIX_API_URL=http://localhost:8080/api
MIX_URL=http://localhost:8080
```

**Importante**: Las variables que empiezan con `MIX_` son las que se inyectan en el código JavaScript durante la compilación.

### 2. Limpiar caché de Laravel

```bash
docker-compose exec app php artisan config:clear
docker-compose exec app php artisan cache:clear
docker-compose exec app php artisan view:clear
```

### 3. Recompilar assets de Vue.js

**Para desarrollo:**
```bash
docker-compose exec node npm run dev
```

**Para producción:**
```bash
docker-compose exec node npm run production
```

**Si quieres que se recompile automáticamente al hacer cambios:**
```bash
docker-compose exec node npm run watch
```

### 4. Limpiar caché del navegador

Después de recompilar, **es muy importante** limpiar la caché del navegador:

- **Chrome/Edge**: `Ctrl + Shift + Delete` o `Ctrl + F5` para forzar recarga
- **Firefox**: `Ctrl + Shift + Delete` o `Ctrl + F5`
- O abre en modo incógnito para probar

### 5. Verificar que los cambios se aplicaron

Abre las herramientas de desarrollador del navegador (F12) y en la consola ejecuta:

```javascript
console.log(process.env.MIX_API_URL);
console.log(process.env.MIX_URL);
```

Deberías ver `http://localhost:8080/api` y `http://localhost:8080` respectivamente.

## 🔍 Verificar Archivos Compilados

Los assets compilados están en `public/js/` y `public/css/`. Si abres estos archivos, deberías ver las URLs con el puerto 8080.

## 🐛 Si Sigue Sin Funcionar

### Opción 1: Limpiar todo y recompilar

```bash
# Detener contenedores
docker-compose down

# Eliminar archivos compilados
rm -rf public/js public/css public/mix-manifest.json

# Levantar contenedores
docker-compose up -d

# Recompilar
docker-compose exec node npm run production
```

### Opción 2: Verificar que el .env se está leyendo correctamente

```bash
docker-compose exec app php artisan tinker
```

Dentro de tinker:
```php
env('MIX_API_URL')
env('MIX_URL')
env('APP_URL')
```

Todos deberían mostrar `http://localhost:8080` o variaciones de eso.

### Opción 3: Verificar el archivo compilado directamente

```bash
# Ver el contenido del archivo JavaScript compilado
cat public/js/app.js | grep -i "8000\|8080"
```

Si ves referencias a 8000, significa que no se recompiló correctamente.

## 📋 Checklist Completo

- [ ] Archivo `.env` actualizado con `MIX_API_URL` y `MIX_URL` en puerto 8080
- [ ] Caché de Laravel limpiada
- [ ] Assets recompilados con `npm run dev` o `npm run production`
- [ ] Caché del navegador limpiada
- [ ] Verificado en consola del navegador que las variables tienen el puerto correcto

## 💡 Nota Importante

**Cada vez que cambies variables que empiezan con `MIX_` en el `.env`, DEBES recompilar los assets** con `npm run dev` o `npm run production`. Laravel Mix inyecta estas variables durante la compilación, no en tiempo de ejecución.

