<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class VentaSesion extends Model
{
    use HasFactory;

    protected $table = 'ventas_sesiones';

    protected $fillable = [
        'venta_id',
        'sesion_id',
    ];

    public function sesion(): BelongsTo
    {
        return $this->belongsTo(Sesion::class,'sesion_id');
    }

    public function venta(): BelongsTo
    {
        return $this->belongsTo(Venta::class,'venta_id');
    }
}
