<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class ValeSesion extends Model
{
    use HasFactory;

    protected $table = 'vales_sessiones';
    
    public $timestamps = false;

    protected $fillable = [
        'vale_id',
        'sesion_id'
    ];

    public function vale(): BelongsTo
    {
        return $this->belongsTo(Vale::class,'vale_id');
    }

    public function sesion(): BelongsTo
    {
        return $this->belongsTo(Sesion::class,'sesion_id');
    }
}
