<?php

namespace App\Models;

use GuzzleHttp\Client;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Laravel\Sanctum\HasApiTokens;
use Spatie\Permission\Traits\HasRoles;
use LaravelAndVueJS\Traits\LaravelPermissionToVueJS;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class User extends Authenticatable
{
    use HasApiTokens;
    use HasRoles;
    use LaravelPermissionToVueJS;
    public const ADMIN_ROL = 'Administrador';
    public const TERA_ROL = 'Terapista';
    public const CLIENTE_ROL = 'Cliente';
    public const VENTA_ROL = 'Venta';
    public const ROLES = [
        self::ADMIN_ROL,
        self::TERA_ROL,
        self::CLIENTE_ROL,
        self::VENTA_ROL,
    ];

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'name',
        'email',
        'telefono',
        'password',
        'estatus',
        'autorizado',
        'cliente_id',
        'tipo_cliente',
        'nota',
        'uuid',
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * Get custom attributes for validator errors.
     *
     * @return array<string, string>
     */
    public function attributes(): array
    {
        return [
            'cliente_id' => 'Cliente',
        ];
    }

    public function jsPermissions()
    {
        return [
            'roles' => $this->getRoleNames(), // Obtiene una colección de roles
            'permissions' => $this->getAllPermissions()->pluck('name'), // Obtiene una colección de permisos
            'tipo_cliente' => $this->tipo_cliente, // Incluye el atributo tipo_cliente
        ];
    }

    /**
     * Handle a passed validation attempt.
     */
    protected function passedValidation(): void
    {
        $this->replace(['cliente_id' => 'Taylor']);
    }

    public function usersSucursales(): HasMany
    {
        return $this->hasMany(UserSucursal::class, 'user_id');
    }

    public function configUsersSucursales(): HasMany
    {
        return $this->hasMany(ConfigUserSucursal::class, 'user_id');
    }

    public function cliente(): BelongsTo
    {
        return $this->belongsTo(Cliente::class,'cliente_id');
    }

    public function tiendas(): HasMany
    {
        return $this->hasMany(Tienda::class, 'user_id')
        ->leftjoin('productos', 'productos.id', '=', 'tiendas.producto_id')
        ->selectRaw('
            tiendas.*,
            productos.nombre,
            productos.precio,
            (productos.iva/100) iva_def,
            (productos.ieps/100) ieps_def,
            (productos.precio*(productos.iva/100)) iva,
            (productos.precio*tiendas.cantidad) subtotal,
            ((productos.precio*tiendas.cantidad) + ((productos.precio*tiendas.cantidad)*(productos.iva/100))) total
        ')
        ->where(['productos.estatus'=>'activo']);
    }

    public static function clientePublico()
    {
        return Cliente::where('rfc', 'XAXX010101000')->first();
    }

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    // protected $casts = [
    //     'email_verified_at' => 'datetime',
    //     'password' => 'hashed',
    // ];
}
