<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

class TipoServicio extends Model
{
    use HasFactory;

    protected $table = 'tipos_servicios';

    protected $fillable = [
        'descripcion',
        'estatus',
    ];

    public function productos(): HasMany
    {
        return $this->hasMany(Producto::class, 'tipo_servicio_id');
    }
}
