<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class TipoBaja extends Model
{
    use HasFactory;

    protected $table = 'tipos_bajas';

    protected $fillable = [
        'descripcion',
        'estatus',
    ];

    public function productosBajas(): HasMany
    {
        return $this->hasMany(tratamiento::class, 'tipo_baja_id');
    }
}
