<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Tienda extends Model
{
    use HasFactory;

    protected $table = 'tiendas';

    protected $fillable = [
        'producto_id',
        'user_id',
        'cantidad',
    ];

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class, 'user_id');
    }

    public function producto(): BelongsTo
    {
        return $this->belongsTo(Producto::class, 'producto_id')
        ->leftjoin('marcas', 'productos.marca_id', '=', 'marcas.id')
        ->leftjoin('tipos_servicios', 'productos.tipo_servicio_id', '=', 'tipos_servicios.id')
        ->leftjoin('tipos_productos', 'productos.tipo_producto_id', '=', 'tipos_productos.id')
        ->selectRaw('
            productos.*,
            marcas.marca,
            tipos_servicios.descripcion tipo_tratamiento,
            tipos_productos.descripcion tipo_producto,
            (iva/100) iva_def,
            (ieps/100) ieps_def,
            (productos.precio*(iva/100)) iva,
            productos.precio total
        ');
    }
}
