<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class SesionTratamiento extends Model
{
    use HasFactory;

    protected $table = 'sesiones_tratamientos';

    protected $fillable = [
        'tratamiento_id',
        'sesion_id'
    ];

    public function sesion(): BelongsTo
    {
        return $this->belongsTo(Sesion::class,'sesion_id');
    }

    public function tratamiento(): BelongsTo
    {
        return $this->belongsTo(Tratamiento::class,'tratamiento_id');
    }
}
