<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class ProductoBaja extends Model
{
    use HasFactory;

    protected $table = 'productos_bajas';

    protected $fillable = [
        'tipo_baja_id',
        'sucursal_id',
        'producto_id',
        'cantidad',
        'observacion',
        'estatus',
    ];

    public function sucursal(): BelongsTo
    {
        return $this->belongsTo(Sucursal::class, 'sucursal_id');
    }

    public function producto(): BelongsTo
    {
        return $this->belongsTo(Producto::class, 'producto_id');
    }

    public function tipoBaja(): BelongsTo
    {
        return $this->belongsTo(TipoBaja::class,'tipo_baja_id');
    }
}
