<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class CorteCaja extends Model
{
    use HasFactory;

    protected $table = 'cortes_cajas';

    protected $fillable = [
        'sucursal_id',
        'total',
        'subtotal',
        'iva',
        'ieps',
        'subtotal',
        'total_efectivo',
        'total_tarjeta_debito',
        'total_tarjeta_credito',
        'total_tranferencia',
        'total_credito',
        'estatus',
        'fecha_registro',
        'fecha_inicio',
        'fecha_fin'
    ];

    public function sucursal(): BelongsTo
    {
        return $this->belongsTo(Sucursal::class, 'sucursal_id');
    }

    public function venta(): HasMany
    {
        return $this->hasMany(VentaCorte::class, 'corte_caja_id');
    }
}
