<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Banco extends Model
{
    use HasFactory;

    protected $table = 'bancos';

    protected $fillable = [
        'nombre',
        'estatus'
    ];

    protected $casts = [
        'created_at' => 'datetime',
        'updated_at' => 'datetime',
        'estatus' => 'string'
    ];

    /**
     * Scope para obtener solo bancos activos
     */
    public function scopeActivo($query)
    {
        return $query->where('estatus', 'activo');
    }

    /**
     * Scope para ordenar por nombre
     */
    public function scopeOrdenadoPorNombre($query)
    {
        return $query->orderBy('nombre', 'asc');
    }

    /**
     * Obtener el nombre en mayúsculas
     */
    public function getNombreAttribute($value)
    {
        return strtoupper($value);
    }

    /**
     * Establecer el nombre en mayúsculas antes de guardar
     */
    public function setNombreAttribute($value)
    {
        $this->attributes['nombre'] = strtoupper($value);
    }
}