<?php

namespace App\Mail;

use App\Models\User;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class AutoAvisoNuevoCliente extends Mailable
{
    use Queueable, SerializesModels;

    public $user;

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct(User $user)
    {
        $this->user = $user;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        if ($this->user->tipo_cliente == 'cliente_linea') {
            return $this->subject('Registro Completado')->view('mails.auto_aviso_nuevo_cliente_local');
        }
        return $this->subject('Registro Completado')->view('mails.auto_aviso_nuevo_cliente');
    }
}
