<?php

namespace App\Http\Controllers;

use App\Models\Vale;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Illuminate\Database\Eloquent\Builder;

class ValeController extends Controller
{


    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show(Vale $vale): JsonResponse
    {
        $vale = Vale::with(['ventaDetalle.venta.cliente', 'ventaDetalle.venta'])
        ->leftjoin('vales_sessiones', 'vales.id', '=', 'vales_sessiones.vale_id')
        ->leftjoin('ventas_detalles', 'vales.id', '=', 'ventas_detalles.vale_id')
        ->leftjoin('ventas', 'ventas_detalles.venta_id', '=', 'ventas.id')
        ->leftjoin('clientes', 'ventas.cliente_id', '=', 'clientes.id')
        ->selectRaw("
            vales.*,
            clientes.id as cliente_id,
            clientes.razonSocial as cliente_nombre,
            clientes.email as cliente_email,
            clientes.celular as cliente_celular,
            date_format(vales.vigencia,'%d-%m-%Y') vigencia_custom,
            date_format(vales.fecha_registro,'%d-%m-%Y') fecha_asignada_custom,
            (
                case
                    when isnull(vales_sessiones.vale_id) then 'Sin asignar'
                    else 'Asignado'
                end
            ) asignado
        ")
        ->where(['vales.id'=>$vale->id])->first();
        return response()->json([
            'data' => $vale,
        ], JsonResponse::HTTP_OK);
    }

    public function paginacion(Request $request): JsonResponse
    {
        $producto=Vale::leftjoin('ventas_detalles', 'vales.id', '=', 'ventas_detalles.vale_id')
        ->leftjoin('ventas', 'ventas_detalles.venta_id', '=', 'ventas.id')
        ->leftjoin('clientes', 'ventas.cliente_id', '=', 'clientes.id')
        ->leftjoin('vales_sessiones', 'vales.id', '=', 'vales_sessiones.vale_id')
        ->selectRaw("
            vales.*,
            clientes.id as cliente_id,
            clientes.razonSocial as cliente_nombre,
            clientes.email as cliente_email,
            clientes.celular as cliente_celular,
            ventas_detalles.venta_id venta_id,
            date_format(vales.vigencia,'%d-%m-%Y') vigencia_custom,
            date_format(vales.fecha_registro,'%d-%m-%Y') fecha_asignada_custom,
            (
                case
                    when isnull(vales_sessiones.vale_id) then 'Sin asignar'
                    else 'Asignado'
                end
            ) asignado
        ")
        ->when($request->search,function (Builder $builder) use ($request) {
            $builder->orWhere('vales.id', 'like', "%{$request->search}%")
            ->orWhere("date_format(vales.fecha_registro,'%d-%m-%Y')", 'like', "%{$request->search}%")
            ->orWhere("date_format(vales.vigencia,'%d-%m-%Y')", 'like', "%{$request->search}%")
            ->orWhere("total", 'like', "%{$request->search}%")
            ->orWhere("clientes.razonSocial", 'like', "%{$request->search}%")
            ->orWhere("clientes.email", 'like', "%{$request->search}%")
            ->orWhere("clientes.celular", 'like', "%{$request->search}%");
        })
        ->where(['vales.estatus'=>'activo'])->orderBy('updated_at','DESC')->paginate($request->perPage);
        return response()->json([
            'data' =>$producto,
        ], JsonResponse::HTTP_OK);
    }
}
