<?php

namespace App\Http\Controllers;

use App\Models\TipoProducto;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Illuminate\Validation\Rule;

class TipoProductoController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request): JsonResponse
    {
        $tipo=TipoProducto::where(['estatus'=>'activo'])->get();
        return response()->json([
            'data' =>$tipo
        ], JsonResponse::HTTP_OK);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request): JsonResponse
    {
        $request->validate([
            'descripcion' => ['required', 'string','max:150'],
            'estatus' => ['required', 'string','max:10']
        ]);

        $tipo = TipoProducto::create($request->only([
            'descripcion',
            'estatus',
        ]));

        return response()->json([
            'data' => $tipo,
        ], JsonResponse::HTTP_OK);
    }


    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show(TipoProducto $tipoProducto): JsonResponse
    {
        return response()->json([
            'data' => $tipoProducto,
        ], JsonResponse::HTTP_OK);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, TipoProducto $tipoProducto): JsonResponse
    {
        $request->validate([
            'descripcion' => ['required', 'string','max:150'],
            'estatus' => ['required', 'string','max:10']
        ]);

        $tipoProducto->update($request->only([
            'descripcion',
            'estatus',
        ]));

        return response()->json([
            'data' => $tipoProducto,
        ], JsonResponse::HTTP_OK);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(TipoProducto $tipoProducto): JsonResponse
    {
        if (\count($tipoProducto->productos) > 0) {
            $tipoProducto->update([
                'estatus' => 'inactivo',
            ]);
        } else {
            $tipoProducto->delete();
        }

        return response()->json(null, JsonResponse::HTTP_NO_CONTENT);
    }
}
