<?php

namespace App\Http\Controllers;

use App\Models\Sucursal;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;

class SucursalController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(): JsonResponse
    {
        $sucursal=Sucursal::where(['estatus'=>'activo'])->get();
        return response()->json([
            'data' =>$sucursal,
        ], JsonResponse::HTTP_OK);
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function all(): JsonResponse
    {
        $sucursal=Sucursal::get();
        return response()->json([
            'data' =>$sucursal,
        ], JsonResponse::HTTP_OK);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request): JsonResponse
    {
        $request->validate([
            'nombre' => ['required', 'string', 'max:200'],
            'correo' => ['required', 'email'],
            'direccion' => ['required', 'string'],
            'estatus' => ['required', 'string'],
            'telefono' => ['max:45']
        ]);

        $sucursal = Sucursal::create($request->only([
            'nombre',
            'correo',
            'direccion',
            'telefono',
            'estatus',
        ]));

        return response()->json([
            'data' => $sucursal,
        ], JsonResponse::HTTP_OK);
    }


    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show(Sucursal $sucursal): JsonResponse
    {
        return response()->json([
            'data' => $sucursal,
        ], JsonResponse::HTTP_OK);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Sucursal $sucursal): JsonResponse
    {
        $request->validate([
            'nombre' => ['required', 'string', 'max:200'],
            'correo' => ['required', 'email'],
            'direccion' => ['required'],
            'estatus' => ['required'],
            'telefono' => ['max:45']
        ]);

        $sucursal->update($request->only([
            'nombre',
            'correo',
            'direccion',
            'telefono',
            'estatus',
        ]));

        return response()->json([
            'data' => $sucursal,
        ], JsonResponse::HTTP_OK);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Sucursal $sucursal): JsonResponse
    {
        if (
            \count($sucursal->expedientes) > 0 || 
            \count($sucursal->sesiones) > 0 || 
            \count($sucursal->horarios) > 0 || 
            \count($sucursal->usersSucursales) > 0 ||
            \count($sucursal->inventarios) > 0 || 
            \count($sucursal->ingresosMercancias) > 0 || 
            \count($sucursal->productosBajas) > 0 || 
            \count($sucursal->ventas) > 0 || 
            \count($sucursal->cortesCajas) > 0
        ) {
            $sucursal->update([
                'estatus' => 'inactivo',
            ]);
        } else {
            $sucursal->delete();
        }

        return response()->json(null, JsonResponse::HTTP_NO_CONTENT);
    }
}
