<?php

namespace App\Http\Controllers;

use App\Models\Cliente;
use App\Models\Expediente;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Illuminate\Validation\Rule;

class ExpedienteController extends Controller
{
    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request): JsonResponse
    {
        $request->validate([
            'cliente_id' => ['required', Rule::exists('clientes', 'id')],
            'sucursal_id' => ['required', Rule::exists('sucursales', 'id')],
            'contenido' => ['required', 'string'],
            'fecha_registro' => ['required','date']
        ]);

        $expediente = Expediente::create($request->only([
            'cliente_id',
            'sucursal_id',
            'session_id',
            'contenido',
            'fecha_registro',
        ]));

        return response()->json([
            'data' => $expediente,
        ], JsonResponse::HTTP_OK);
    }


    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show(Expediente $expediente): JsonResponse
    {
        return response()->json([
            'data' => [
                'expediente'=>$expediente,
                'sucursal'=>$expediente->sucursal,
            ],
        ], JsonResponse::HTTP_OK);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Expediente $expediente): JsonResponse
    {
        $request->validate([
            'cliente_id' => ['required', Rule::exists('clientes', 'id')],
            'sucursal_id' => ['required', Rule::exists('sucursales', 'id')],
            'contenido' => ['required', 'string'],
            'fecha_registro' => ['required','date']
        ]);

        $expediente->update($request->only([
            'cliente_id',
            'sucursal_id',
            'session_id',
            'contenido',
            'fecha_registro',
        ]));

        return response()->json([
            'data' => $expediente,
        ], JsonResponse::HTTP_OK);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Expediente $expediente): JsonResponse
    {
        $expediente->delete();

        return response()->json(null, JsonResponse::HTTP_NO_CONTENT);
    }
}
