<?php

namespace App\Helpers;

use App\Models\ConfigCorreo;
use Illuminate\Support\Facades\Storage;

class CorreoHelper
{
    /**
     * Obtener el correo de destino según la configuración
     */
    public static function getCorreoDestino($correoOriginal = null)
    {
        $config = ConfigCorreo::getConfiguracionActiva();
        
        if ($config && $config->modo_prueba) {
            return $config->correo_prueba;
        }
        
        return $correoOriginal ?? env('MAIL_USERNAME', 'deyvijesusgomezmoha@gmail.com');
    }

    /**
     * Verificar si el modo prueba está activo
     */
    public static function modoPruebaActivo()
    {
        $config = ConfigCorreo::getConfiguracionActiva();
        return $config && $config->modo_prueba;
    }

    /**
     * Obtener información completa de la configuración
     */
    public static function getConfiguracion()
    {
        return ConfigCorreo::getConfiguracionActiva();
    }

    /**
     * Obtener la URL del logo de la empresa para correos
     */
    public static function getLogoUrl()
    {
        $appUrl = rtrim(config('app.url'), '/');
        
        // Primero buscar en public/images/default (archivos compilados)
        $publicLogoPath = public_path('images/default');
        if (is_dir($publicLogoPath)) {
            $files = glob($publicLogoPath . '/logo_negro*.png');
            if (!empty($files)) {
                $filename = basename($files[0]);
                return $appUrl . '/images/default/' . $filename;
            }
        }
        
        // Si no está en public, buscar en storage/app/public/images/default
        $storageLogoPath = storage_path('app/public/images/default');
        if (is_dir($storageLogoPath)) {
            $files = glob($storageLogoPath . '/logo_negro*.png');
            if (!empty($files)) {
                $filename = basename($files[0]);
                // Usar Storage::url() para generar la URL correcta
                return Storage::url('images/default/' . $filename);
            }
        }
        
        // También buscar directamente en storage usando Storage facade
        if (Storage::disk('public')->exists('images/default')) {
            $files = Storage::disk('public')->files('images/default');
            foreach ($files as $file) {
                if (strpos(basename($file), 'logo_negro') === 0 && pathinfo($file, PATHINFO_EXTENSION) === 'png') {
                    return Storage::url($file);
                }
            }
        }
        
        // Fallback: usar la ruta conocida con hash en public
        return $appUrl . '/images/default/logo_negro-a070b23332af43f16cbbf5db8681992b.png';
    }
}
