# Sistema de Configuración Visual de Impresiones

Este sistema permite configurar de forma visual todas las propiedades de impresión de tickets, facturas, recibos y reportes, almacenando la configuración en la base de datos.

## Características

- ✅ Configuración visual completa de impresiones
- ✅ Almacenamiento en base de datos
- ✅ Múltiples tipos de impresión (ticket, factura, recibo, reporte)
- ✅ Configuraciones activas y predeterminadas
- ✅ Duplicación de configuraciones
- ✅ Fallback a configuración por defecto
- ✅ Interfaz intuitiva con Vue 3

## Archivos Creados/Modificados

### Backend (Laravel)

1. **`database/sql/actualizaciones.sql`** - Tabla de configuración de impresiones
2. **`app/Models/ConfigImpresion.php`** - Modelo para manejar configuraciones
3. **`app/Http/Controllers/ConfigImpresionController.php`** - Controlador CRUD
4. **`routes/api.php`** - Rutas API para el módulo

### Frontend (Vue 3)

5. **`resources/js/src/views/configuracion/ConfigImpresiones.vue`** - Componente de configuración visual
6. **`resources/js/src/services/ImpresionService.js`** - Servicio de impresión
7. **`resources/js/src/views/ventas/vender.vue`** - Función de impresión modificada

## Instalación

### 1. Ejecutar SQL
Ejecuta el archivo `database/sql/actualizaciones.sql` en tu base de datos para crear la tabla y datos iniciales.

### 2. Configurar Rutas
Las rutas ya están añadidas en `routes/api.php`. Asegúrate de que estén dentro del middleware `auth:sanctum`.

### 3. Añadir al Menú
Añade el componente `ConfigImpresiones.vue` a tu menú de navegación:

```javascript
// En tu router o menú
{
  path: '/configuracion/impresiones',
  name: 'ConfigImpresiones',
  component: () => import('@/views/configuracion/ConfigImpresiones.vue')
}
```

## Uso

### Configuración Visual

1. Accede al módulo "Configuración de Impresiones"
2. Crea una nueva configuración o edita una existente
3. Configura todos los parámetros visualmente:
   - **Información Básica**: Nombre, tipo, estado
   - **Dimensiones**: Ancho/alto del papel, márgenes
   - **Fuentes**: Tipo, tamaños, color, peso
   - **Alineación**: Títulos y texto
   - **Elementos**: Qué mostrar (logo, fecha, cliente, etc.)
   - **Tabla**: Padding, ancho

### Uso en Código

```javascript
// Importar el servicio
import impresionService from '@/services/ImpresionService';

// Imprimir con configuración de BD
await impresionService.imprimirConConfiguracion('ticket-content', 'ticket');

// Obtener configuración actual
const config = impresionService.getConfiguracionActiva('ticket');
```

### API Endpoints

```
GET    /api/config-impresiones/all              - Listar configuraciones
GET    /api/config-impresiones/activa           - Obtener configuración activa
GET    /api/config-impresiones/{id}             - Obtener configuración específica
POST   /api/config-impresiones/create           - Crear configuración
PUT    /api/config-impresiones/{id}/edit        - Actualizar configuración
DELETE /api/config-impresiones/{id}             - Eliminar configuración
PUT    /api/config-impresiones/{id}/activar     - Activar configuración
PUT    /api/config-impresiones/{id}/predeterminada - Establecer como predeterminada
POST   /api/config-impresiones/{id}/duplicar    - Duplicar configuración
GET    /api/config-impresiones/estilos/{id}     - Obtener estilos CSS
```

## Parámetros Configurables

### Dimensiones del Papel
- **Ancho**: 50-200mm
- **Alto**: 0-500mm (0 = automático)
- **Márgenes**: Superior, inferior, izquierdo, derecho (0-50mm)

### Fuentes
- **Fuente Principal**: Nombre de la fuente
- **Tamaños**: Principal (8-72px), Título, Subtítulo, Detalle
- **Color**: Código hexadecimal
- **Peso**: Normal, Bold, Lighter, Bolder
- **Interlineado**: 0.5-3.0

### Alineación
- **Título**: Izquierda, Centro, Derecha
- **Texto**: Izquierda, Centro, Derecha

### Elementos a Mostrar
- Logo
- Fecha
- Hora
- Cliente
- Empleado
- Observaciones

### Tabla
- **Padding**: 0-20mm
- **Ancho**: 50-100%

## Tipos de Impresión

- **ticket**: Tickets de venta
- **factura**: Facturas
- **recibo**: Recibos
- **reporte**: Reportes

## Funcionalidades

### Configuraciones Activas
- Solo una configuración por tipo puede estar activa
- Al activar una, se desactivan automáticamente las demás del mismo tipo

### Configuraciones Predeterminadas
- Solo una configuración por tipo puede ser predeterminada
- Se usa cuando no hay configuración activa

### Duplicación
- Permite crear copias de configuraciones existentes
- Útil para crear variaciones rápidamente

### Fallback
- Si no hay configuración activa, usa la predeterminada
- Si no hay configuración en BD, usa configuración hardcodeada

## Ejemplo de Uso Completo

```javascript
// En tu componente Vue
import impresionService from '@/services/ImpresionService';

export default {
  methods: {
    async imprimirTicket() {
      try {
        // Imprimir usando configuración de BD
        await impresionService.imprimirConConfiguracion('ticket-content', 'ticket');
        this.$toast.success('Ticket impreso correctamente');
      } catch (error) {
        this.$toast.error('Error al imprimir ticket');
      }
    }
  }
}
```

## Notas Importantes

1. **Permisos**: Asegúrate de que los usuarios tengan permisos para acceder al módulo de configuración
2. **Backup**: Haz backup de las configuraciones antes de cambios importantes
3. **Testing**: Prueba las configuraciones en diferentes impresoras
4. **Performance**: Las configuraciones se cachean en memoria para mejor rendimiento

## Troubleshooting

### Error al cargar configuración
- Verifica que la tabla `config_impresiones` exista
- Revisa los logs de Laravel para errores de API

### Impresión no funciona
- El sistema tiene fallback automático a configuración original
- Revisa la consola del navegador para errores

### Estilos no se aplican
- Verifica que la configuración esté activa
- Revisa que los valores estén dentro de los rangos permitidos
