# 🔍 Diagnóstico de Base de Datos

## Problema
Laravel reporta que la columna `tipo_producto_id` no existe, pero tú ves que sí existe en tu cliente SQL.

## Posibles Causas

1. **Laravel se está conectando a una base de datos diferente**
   - Tu cliente SQL muestra: `@spa (pruebas)`
   - Docker está configurado para: `egurrola`
   - Laravel podría estar usando una base de datos diferente

2. **Caché de configuración de Laravel**
   - Laravel puede tener la configuración en caché
   - Necesitas limpiar el caché

3. **La columna no existe en la base de datos de Docker**
   - La columna existe en tu base de datos externa
   - Pero no en la base de datos dentro del contenedor Docker

## Soluciones

### 1. Verificar qué base de datos está usando Laravel

Ejecuta estos comandos en tu terminal (dentro de WSL o usando docker-compose):

```bash
# Ver la configuración de base de datos que Laravel está usando
docker-compose exec app php artisan tinker --execute="echo 'DB: ' . config('database.connections.mysql.database') . PHP_EOL; echo 'Host: ' . config('database.connections.mysql.host') . PHP_EOL;"

# Verificar si la columna existe en la base de datos de Docker
docker-compose exec mysql mysql -uegurrola_user -pegurrola_password egurrola -e "SHOW COLUMNS FROM productos LIKE 'tipo_producto_id';"

# Ver todas las columnas de la tabla productos
docker-compose exec mysql mysql -uegurrola_user -pegurrola_password egurrola -e "DESCRIBE productos;"
```

### 2. Limpiar caché de Laravel

```bash
docker-compose exec app php artisan config:clear
docker-compose exec app php artisan cache:clear
docker-compose exec app php artisan route:clear
docker-compose exec app php artisan view:clear
```

### 3. Verificar el archivo .env

Asegúrate de que tu archivo `.env` tenga la configuración correcta:

```env
DB_CONNECTION=mysql
DB_HOST=mysql
DB_PORT=3306
DB_DATABASE=egurrola
DB_USERNAME=egurrola_user
DB_PASSWORD=egurrola_password
```

**IMPORTANTE**: Si estás usando una base de datos diferente (como "pruebas" o "spa"), cambia `DB_DATABASE` en el `.env`:

```env
DB_DATABASE=pruebas
# o
DB_DATABASE=spa
```

### 4. Si la columna no existe en la base de datos de Docker

Si la columna existe en tu base de datos externa pero no en Docker, necesitas agregarla:

```bash
# Conectarse a MySQL en Docker
docker-compose exec mysql mysql -uegurrola_user -pegurrola_password egurrola

# Dentro de MySQL, ejecutar:
ALTER TABLE productos ADD COLUMN tipo_producto_id INT(11) NULL AFTER estatus;
ALTER TABLE productos ADD COLUMN tipo_servicio_id INT(11) NULL AFTER estatus;

# Si necesitas las foreign keys:
ALTER TABLE productos 
ADD CONSTRAINT productos_tipo_producto_id 
FOREIGN KEY (tipo_producto_id) REFERENCES tipos_productos(id);

ALTER TABLE productos 
ADD CONSTRAINT productos_tipo_servicio_id 
FOREIGN KEY (tipo_servicio_id) REFERENCES tipos_servicios(id);
```

### 5. Verificar que estás usando la misma base de datos

**En tu cliente SQL (Navicat, DBeaver, etc.)**:
- Verifica que estés conectado a la misma base de datos que Laravel
- Si Laravel usa `egurrola`, conéctate a `egurrola`
- Si Laravel usa `pruebas`, conéctate a `pruebas`

**Puerto importante**: 
- Docker mapea MySQL al puerto **3307** en tu máquina local
- Asegúrate de conectarte al puerto correcto

## Verificación Rápida

Ejecuta este comando para ver toda la información de conexión:

```bash
docker-compose exec app php artisan tinker --execute="
\$db = config('database.connections.mysql');
echo 'Host: ' . \$db['host'] . PHP_EOL;
echo 'Database: ' . \$db['database'] . PHP_EOL;
echo 'Username: ' . \$db['username'] . PHP_EOL;
echo 'Port: ' . \$db['port'] . PHP_EOL;
"
```

