<?php

namespace App\Services;

use App\Models\OrdenLavanderia;

class ImpresionInstruccionesLavanderiaService
{
    /**
     * Analiza detalles e instrucciones y devuelve banderas para cada área.
     * Aquí podrías integrar la lógica concreta de impresión (impresora térmica).
     */
    public function obtenerAlertasPorArea(OrdenLavanderia $orden): array
    {
        $texto = mb_strtolower(($orden->detalles_ropa ?? '').' '.($orden->instrucciones ?? ''), 'UTF-8');

        $alertas = [
            'lavado' => false,
            'secado' => false,
            'planchado' => false,
        ];

        if (str_contains($texto, 'no usar secadora')) {
            $alertas['secado'] = true;
        }

        if (str_contains($texto, 'planchado con mucho almidón') || str_contains($texto, 'mucho almidon')) {
            $alertas['planchado'] = true;
        }

        if (str_contains($texto, 'no usar lavadora')) {
            $alertas['lavado'] = true;
        }

        return $alertas;
    }
}

