<?php

namespace App\Repositories;

use App\Models\OrdenLavanderia;
use App\Repositories\Contracts\OrdenLavanderiaRepositoryInterface;
use Illuminate\Contracts\Pagination\LengthAwarePaginator;
use Illuminate\Support\Collection;

class EloquentOrdenLavanderiaRepository implements OrdenLavanderiaRepositoryInterface
{
    public function create(array $data): OrdenLavanderia
    {
        return OrdenLavanderia::create($data);
    }

    public function findById(int $id): ?OrdenLavanderia
    {
        return OrdenLavanderia::find($id);
    }

    public function findByFolio(string $folioUnico): ?OrdenLavanderia
    {
        return OrdenLavanderia::where('folio_unico', $folioUnico)->first();
    }

    public function update(OrdenLavanderia $orden, array $data): OrdenLavanderia
    {
        $orden->fill($data);
        $orden->save();

        return $orden;
    }

    public function getPendientesEnProceso(): Collection
    {
        return OrdenLavanderia::whereIn('estatus', [
            OrdenLavanderia::ESTATUS_PENDIENTE,
            OrdenLavanderia::ESTATUS_EN_PROCESO,
        ])->orderBy('is_priority', 'desc')
            ->orderBy('current_step_started_at', 'asc')
            ->get();
    }

    public function paginate(array $filters = [], int $perPage = 20): LengthAwarePaginator
    {
        $query = OrdenLavanderia::query();

        if (!empty($filters['estatus'])) {
            $query->where('estatus', $filters['estatus']);
        }

        if (!empty($filters['current_step'])) {
            $query->where('current_step', $filters['current_step']);
        }

        if (!empty($filters['cliente_nombre'])) {
            $query->where('cliente_nombre', 'like', '%'.$filters['cliente_nombre'].'%');
        }

        if (!empty($filters['folio_unico'])) {
            $query->where('folio_unico', 'like', '%'.$filters['folio_unico'].'%');
        }

        if (!empty($filters['is_priority'])) {
            $query->where('is_priority', (bool) $filters['is_priority']);
        }

        return $query->orderByDesc('created_at')->paginate($perPage);
    }
}

