<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Laravel\Sanctum\HasApiTokens;
use Spatie\Permission\Traits\HasRoles;
use LaravelAndVueJS\Traits\LaravelPermissionToVueJS;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class User extends Authenticatable
{
    use HasApiTokens;
    use HasRoles;
    use LaravelPermissionToVueJS;
    public const ADMIN_ROL = 'Administrador';
    public const RECEPCIONISTA_ROL = 'Recepcionista';
    public const OPERADOR_ROL = 'Operador';
    public const ROLES = [
        self::ADMIN_ROL,
        self::RECEPCIONISTA_ROL,
        self::OPERADOR_ROL,
    ];

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'name',
        'email',
        'password',
        'estatus',
        'autorizado',
        'cliente_id',
        'nota',
        'uuid',
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * Relación con órdenes de lavandería creadas (para Recepcionista)
     */
    public function ordenesLavanderia(): HasMany
    {
        return $this->hasMany(\App\Models\OrdenLavanderia::class, 'usuario_recepcionista_id');
    }
}
